/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.Connectable;
import com.spotify.mobius.Connection;
import com.spotify.mobius.functions.Consumer;
import com.spotify.mobius.internal_util.Preconditions;
import javax.annotation.Nonnull;
import rx.Emitter;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.plugins.RxJavaHooks;
import rx.subjects.PublishSubject;

public final class RxConnectables {
    private RxConnectables() {
    }

    public static <I, O> Connectable<I, O> fromTransformer(final Observable.Transformer<I, O> transformer) {
        Preconditions.checkNotNull(transformer);
        return new Connectable<I, O>(){

            @Nonnull
            public Connection<I> connect(final Consumer<O> output) {
                final PublishSubject subject = PublishSubject.create();
                final Subscription subscription = subject.compose(transformer).subscribe(new Observer<O>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        RxJavaHooks.onError((Throwable)e);
                    }

                    public void onNext(O e) {
                        output.accept(e);
                    }
                });
                return new Connection<I>(){

                    public void accept(I effect) {
                        if (subscription.isUnsubscribed()) {
                            throw new IllegalStateException("Effect handlers cannot perform effects after they've been disposed of");
                        }
                        subject.onNext(effect);
                    }

                    public void dispose() {
                        subscription.unsubscribe();
                    }
                };
            }
        };
    }

    public static <I, O> Observable.Transformer<I, O> toTransformer(final Connectable<I, O> connectable, final Emitter.BackpressureMode backpressureMode) {
        return new Observable.Transformer<I, O>(){

            public Observable<O> call(final Observable<I> upstream) {
                return Observable.create((Action1)new Action1<Emitter<O>>(){

                    public void call(final Emitter<O> emitter) {
                        Consumer output = new Consumer<O>(){

                            public void accept(O value) {
                                emitter.onNext(value);
                            }
                        };
                        final Connection input = connectable.connect(output);
                        final Subscription subscription = upstream.subscribe(new Action1<I>(){

                            public void call(I f) {
                                input.accept(f);
                            }
                        }, (Action1)new Action1<Throwable>(){

                            public void call(Throwable throwable) {
                                emitter.onError(throwable);
                            }
                        }, new Action0(){

                            public void call() {
                                emitter.onCompleted();
                            }
                        });
                        emitter.setCancellation(new Cancellable(){

                            public void cancel() throws Exception {
                                subscription.unsubscribe();
                                input.dispose();
                            }
                        });
                    }
                }, (Emitter.BackpressureMode)backpressureMode);
            }
        };
    }

    public static <I, O> Observable.Transformer<I, O> toTransformer(Connectable<I, O> connectable) {
        return RxConnectables.toTransformer(connectable, Emitter.BackpressureMode.NONE);
    }
}

