/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.MobiusLoop;
import com.spotify.mobius.functions.Consumer;
import com.spotify.mobius.rx.UnrecoverableIncomingException;
import java.util.Set;
import javax.annotation.Nullable;
import rx.Emitter;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Cancellable;

class RxMobiusLoop<E, M, F>
implements Observable.Transformer<E, M> {
    private final MobiusLoop.Factory<M, E, F> loopFactory;
    private final M startModel;
    @Nullable
    private final Set<F> startEffects;

    RxMobiusLoop(MobiusLoop.Factory<M, E, F> loopFactory, M loopStart, @Nullable Set<F> effects) {
        this.loopFactory = loopFactory;
        this.startModel = loopStart;
        this.startEffects = effects;
    }

    public Observable<M> call(final Observable<E> events) {
        return Observable.create((Action1)new Action1<Emitter<M>>(){

            public void call(final Emitter<M> emitter) {
                final MobiusLoop loop = RxMobiusLoop.this.startEffects == null ? RxMobiusLoop.this.loopFactory.startFrom(RxMobiusLoop.this.startModel) : RxMobiusLoop.this.loopFactory.startFrom(RxMobiusLoop.this.startModel, RxMobiusLoop.this.startEffects);
                loop.observe(new Consumer<M>(){

                    public void accept(M newModel) {
                        emitter.onNext(newModel);
                    }
                });
                final Subscription eventSubscription = events.subscribe(new Observer<E>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        emitter.onError((Throwable)new UnrecoverableIncomingException(e));
                    }

                    public void onNext(E event) {
                        loop.dispatchEvent(event);
                    }
                });
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        loop.dispose();
                        eventSubscription.unsubscribe();
                    }
                });
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE);
    }
}

