/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.mobius.rx;

import com.spotify.mobius.EventSource;
import com.spotify.mobius.disposables.Disposable;
import com.spotify.mobius.functions.Consumer;
import com.spotify.mobius.internal_util.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import rx.Emitter;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Cancellable;
import rx.plugins.RxJavaHooks;

public final class RxEventSources {
    private RxEventSources() {
    }

    @SafeVarargs
    public static <E> EventSource<E> fromObservables(Observable<E> ... observables) {
        final Observable eventSource = Observable.merge(observables);
        return new EventSource<E>(){

            @Nonnull
            public Disposable subscribe(Consumer<E> eventConsumer) {
                AtomicBoolean disposed = new AtomicBoolean();
                Subscription subscription = eventSource.subscribe(value -> {
                    AtomicBoolean atomicBoolean = disposed;
                    synchronized (atomicBoolean) {
                        if (!disposed.get()) {
                            eventConsumer.accept(value);
                        }
                    }
                }, RxJavaHooks::onError);
                return () -> {
                    AtomicBoolean atomicBoolean = disposed;
                    synchronized (atomicBoolean) {
                        subscription.unsubscribe();
                        disposed.set(true);
                    }
                };
            }
        };
    }

    public static <E> Observable<E> toObservable(final EventSource<E> eventSource, Emitter.BackpressureMode backpressureMode) {
        Preconditions.checkNotNull(eventSource);
        Preconditions.checkNotNull((Object)backpressureMode);
        return Observable.create((Action1)new Action1<Emitter<E>>(){

            public void call(final Emitter<E> emitter) {
                final Disposable disposable = eventSource.subscribe(new Consumer<E>(){

                    public void accept(E value) {
                        emitter.onNext(value);
                    }
                });
                emitter.setCancellation(new Cancellable(){

                    public void cancel() throws Exception {
                        disposable.dispose();
                    }
                });
            }
        }, (Emitter.BackpressureMode)backpressureMode);
    }
}

