/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx;

import com.spotify.apollo.AppInit;
import com.spotify.apollo.httpservice.HttpService;
import com.spotify.apollo.httpservice.LoadingException;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.styx.StyxApi;
import com.spotify.styx.StyxScheduler;
import com.spotify.styx.api.AuthenticatorFactory;
import com.spotify.styx.monitoring.MetricsStats;
import com.spotify.styx.monitoring.StatsFactory;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceConfiguration;
import io.opencensus.exporter.trace.stackdriver.StackdriverTraceExporter;
import java.io.IOException;
import java.time.Instant;
import javaslang.Function1;

public class StyxService {
    private static final String SERVICE_NAME = "styx-standalone";

    private StyxService() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws LoadingException, IOException {
        StackdriverTraceExporter.createAndRegister((StackdriverTraceConfiguration)StackdriverTraceConfiguration.builder().build());
        AppInit init = env -> {
            MetricsStats stats = new MetricsStats((SemanticMetricRegistry)env.resolve(SemanticMetricRegistry.class), Instant::now);
            StatsFactory statsFactory = ignored -> stats;
            AuthenticatorFactory authenticatorFactory = arg_0 -> ((Function1)Function1.of(arg_0 -> AuthenticatorFactory.DEFAULT.apply(arg_0)).memoized()).apply(arg_0);
            StyxScheduler scheduler = StyxScheduler.newBuilder().setServiceName(SERVICE_NAME).setStatsFactory(statsFactory).setAuthenticatorFactory(authenticatorFactory).build();
            StyxApi api = StyxApi.newBuilder().setServiceName(SERVICE_NAME).setStatsFactory(statsFactory).setAuthenticatorFactory(authenticatorFactory).build();
            scheduler.create(env);
            api.create(env);
        };
        HttpService.boot((AppInit)init, (String)SERVICE_NAME, (String[])args);
    }
}

