/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.burst;

import com.squareup.burst.Burst;
import com.squareup.burst.BurstMethod;
import com.squareup.burst.BurstRunner;
import com.squareup.burst.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public final class BurstJUnit4
extends Suite {
    public BurstJUnit4(Class<?> cls) throws InitializationError {
        super(cls, BurstJUnit4.explode(cls));
    }

    static List<Runner> explode(Class<?> cls) throws InitializationError {
        Util.checkNotNull(cls, (String)"cls");
        TestClass testClass = new TestClass(cls);
        List testMethods = testClass.getAnnotatedMethods(Test.class);
        ArrayList<FrameworkMethod> burstMethods = new ArrayList<FrameworkMethod>(testMethods.size());
        for (FrameworkMethod testMethod : testMethods) {
            Method method = testMethod.getMethod();
            for (Enum[] methodArgs : Burst.explodeArguments((Method)method)) {
                burstMethods.add(new BurstMethod(method, methodArgs));
            }
        }
        Constructor<?> constructor = BurstJUnit4.findConstructor(cls);
        Enum[][] constructorArgsList = Burst.explodeArguments(constructor);
        ArrayList<BurstRunner> burstRunners = new ArrayList<BurstRunner>(constructorArgsList.length);
        for (Enum[] constructorArgs : constructorArgsList) {
            burstRunners.add(new BurstRunner(cls, constructor, constructorArgs, burstMethods));
        }
        return Collections.unmodifiableList(burstRunners);
    }

    static Constructor<?> findConstructor(Class<?> cls) {
        Util.checkNotNull(cls, (String)"cls");
        Constructor<?>[] constructors = cls.getConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        throw new IllegalStateException(cls.getName() + " requires a single public constructor.");
    }

    static String nameWithArguments(String name, Enum<?>[] arguments) {
        if (arguments.length == 0) {
            return name;
        }
        return name + '[' + Burst.friendlyName((Enum[])arguments) + ']';
    }
}

