/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.burst;

import com.squareup.burst.Burst;
import com.squareup.burst.BurstMethod;
import com.squareup.burst.BurstRunner;
import com.squareup.burst.BurstableConstructor;
import com.squareup.burst.ParentRunnerSpy;
import com.squareup.burst.TestConstructor;
import com.squareup.burst.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public final class BurstJUnit4
extends Suite {
    public BurstJUnit4(Class<?> cls) throws InitializationError {
        super(cls, BurstJUnit4.explode(cls));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        List filteredChildren = ParentRunnerSpy.getFilteredChildren(this);
        for (Runner child : new ArrayList(filteredChildren)) {
            try {
                filter.apply((Object)child);
            }
            catch (NoTestsRemainException e) {
                filteredChildren.remove(child);
            }
        }
        if (filteredChildren.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    static List<Runner> explode(Class<?> cls) throws InitializationError {
        Util.checkNotNull(cls, (String)"cls");
        TestClass testClass = new TestClass(cls);
        List testMethods = testClass.getAnnotatedMethods(Test.class);
        ArrayList<FrameworkMethod> burstMethods = new ArrayList<FrameworkMethod>(testMethods.size());
        for (FrameworkMethod testMethod : testMethods) {
            Method method = testMethod.getMethod();
            for (Enum[] methodArgs : Burst.explodeArguments((Method)method)) {
                burstMethods.add(new BurstMethod(method, methodArgs));
            }
        }
        TestConstructor constructor = BurstableConstructor.findSingle(cls);
        Enum[][] constructorArgsList = Burst.explodeArguments((TestConstructor)constructor);
        ArrayList<BurstRunner> burstRunners = new ArrayList<BurstRunner>(constructorArgsList.length);
        for (Enum[] constructorArgs : constructorArgsList) {
            burstRunners.add(new BurstRunner(cls, constructor, constructorArgs, burstMethods));
        }
        return Collections.unmodifiableList(burstRunners);
    }

    static String nameWithArguments(String name, Enum<?>[] arguments, Annotation[][] argumentAnnotations) {
        if (arguments.length == 0) {
            return name;
        }
        return name + '[' + Burst.friendlyName((Enum[])arguments, (Annotation[][])argumentAnnotations) + ']';
    }
}

