/*
 * Decompiled with CFR 0.152.
 */
package flow.path;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.LayoutInflater;
import flow.path.PathContextFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class Path {
    static final Path ROOT = new Path(){};
    private transient List<Path> elements;

    public static PathContextFactory contextFactory() {
        return new ContextFactory();
    }

    public static PathContextFactory contextFactory(PathContextFactory delegate) {
        return new ContextFactory(delegate);
    }

    public static <T extends Path> T get(Context context) {
        LocalPathWrapper wrapper = LocalPathWrapper.get(context);
        if (wrapper == null) {
            throw new IllegalArgumentException("Supplied context has no Path");
        }
        return (T)((Path)wrapper.localScreen);
    }

    protected void build(Builder builder) {
    }

    final List<Path> elements() {
        if (this.elements == null) {
            Builder builder = new Builder();
            this.build(builder);
            if (builder.isNotTail(this)) {
                builder.append(this);
            }
            this.elements = builder.elements;
        }
        return this.elements;
    }

    final boolean isRoot() {
        return this == ROOT;
    }

    private static final class ContextFactory
    implements PathContextFactory {
        private final PathContextFactory delegate;

        public ContextFactory() {
            this.delegate = null;
        }

        public ContextFactory(PathContextFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public Context setUpContext(Path path, Context parentContext) {
            if (this.delegate != null) {
                parentContext = this.delegate.setUpContext(path, parentContext);
            }
            return new LocalPathWrapper(parentContext, path);
        }

        @Override
        public void tearDownContext(Context context) {
            if (this.delegate != null) {
                this.delegate.tearDownContext(context);
            }
        }
    }

    private static final class LocalPathWrapper
    extends ContextWrapper {
        static final String LOCAL_WRAPPER_SERVICE = "flow_local_screen_context_wrapper";
        private LayoutInflater inflater;
        final Object localScreen;

        static LocalPathWrapper get(Context context) {
            return (LocalPathWrapper)((Object)context.getSystemService(LOCAL_WRAPPER_SERVICE));
        }

        LocalPathWrapper(Context base, Object localScreen) {
            super(base);
            this.localScreen = localScreen;
        }

        public Object getSystemService(String name) {
            if (LOCAL_WRAPPER_SERVICE.equals(name)) {
                return this;
            }
            if ("layout_inflater".equals(name)) {
                if (this.inflater == null) {
                    this.inflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
                }
                return this.inflater;
            }
            return super.getSystemService(name);
        }
    }

    public static final class Builder {
        private final List<Path> elements = new ArrayList<Path>();

        Builder() {
            this.elements.add(ROOT);
        }

        public void append(Path path) {
            this.elements.add(path);
        }

        private boolean isNotTail(Path path) {
            return !path.equals(this.elements.get(this.elements.size() - 1));
        }
    }
}

