/*
 * Decompiled with CFR 0.152.
 */
package flow.path;

import android.view.View;
import android.view.ViewGroup;
import flow.Flow;
import flow.ViewState;
import flow.path.Path;
import flow.path.PathContainerView;
import flow.path.Preconditions;

public abstract class PathContainer {
    private final int tagKey;

    protected PathContainer(int tagKey) {
        this.tagKey = tagKey;
    }

    public final void executeTraversal(PathContainerView view, Flow.Traversal traversal, Flow.TraversalCallback callback) {
        Path oldPath;
        ViewGroup oldChild = view.getCurrentChild();
        Path path = (Path)traversal.destination.top();
        ViewState viewState = traversal.destination.currentViewState();
        ViewGroup containerView = view.getContainerView();
        TraversalState traversalState = this.ensureTag(containerView);
        if (oldChild != null && (oldPath = Preconditions.checkNotNull(traversalState.toPath, "Container view has child %s with no path", oldChild.toString())).equals(path)) {
            callback.onTraversalCompleted();
            return;
        }
        traversalState.setNextEntry(path, viewState);
        this.performTraversal(containerView, traversalState, traversal.direction, callback);
    }

    protected abstract void performTraversal(ViewGroup var1, TraversalState var2, Flow.Direction var3, Flow.TraversalCallback var4);

    private TraversalState ensureTag(ViewGroup container) {
        TraversalState traversalState = (TraversalState)container.getTag(this.tagKey);
        if (traversalState == null) {
            traversalState = new TraversalState();
            container.setTag(this.tagKey, (Object)traversalState);
        }
        return traversalState;
    }

    protected static final class TraversalState {
        private Path fromPath;
        private ViewState fromViewState;
        private Path toPath;
        private ViewState toViewState;

        protected TraversalState() {
        }

        public void setNextEntry(Path path, ViewState viewState) {
            this.fromPath = this.toPath;
            this.fromViewState = this.toViewState;
            this.toPath = path;
            this.toViewState = viewState;
        }

        public Path fromPath() {
            return this.fromPath;
        }

        public Path toPath() {
            return this.toPath;
        }

        public void saveViewState(View view) {
            this.fromViewState.save(view);
        }

        public void restoreViewState(View view) {
            this.toViewState.restore(view);
        }
    }
}

