/*
 * Decompiled with CFR 0.152.
 */
package flow.path;

import android.content.Context;
import android.content.ContextWrapper;
import flow.path.Path;
import flow.path.PathContextFactory;
import flow.path.Preconditions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PathContext
extends ContextWrapper {
    private static final String SERVICE_NAME = "PATH_CONTEXT";
    private final Path path;
    private final Map<Path, Context> contexts;

    PathContext(Context baseContext, Path path, Map<Path, Context> contexts) {
        super(baseContext);
        Preconditions.checkArgument(baseContext != null, "Leaf context may not be null.", new Object[0]);
        Preconditions.checkArgument(path.elements().size() == contexts.size(), "Path and context map are not the same size, path has %d elements and there are %d contexts", path.elements().size(), contexts.size());
        if (!path.isRoot()) {
            Path leafPath = path.elements().get(path.elements().size() - 1);
            Preconditions.checkArgument(baseContext == contexts.get(leafPath), "For a non-root Path, baseContext must be Path leaf's context.", new Object[0]);
        }
        this.path = path;
        this.contexts = contexts;
    }

    public static PathContext root(Context baseContext) {
        return new PathContext(baseContext, Path.ROOT, Collections.singletonMap(Path.ROOT, baseContext));
    }

    public static PathContext create(PathContext preserve, Path path, PathContextFactory factory) {
        Path element;
        if (path == Path.ROOT) {
            throw new IllegalArgumentException("Path is empty.");
        }
        List<Path> elements = path.elements();
        LinkedHashMap<Path, Context> contexts = new LinkedHashMap<Path, Context>();
        Context baseContext = null;
        Iterator<Path> pathIterator = elements.iterator();
        Iterator<Path> basePathIterator = preserve.path.elements().iterator();
        while (pathIterator.hasNext() && basePathIterator.hasNext()) {
            element = pathIterator.next();
            Path basePathElement = basePathIterator.next();
            if (basePathElement.equals(element)) {
                baseContext = preserve.contexts.get(element);
                contexts.put(element, baseContext);
                continue;
            }
            baseContext = factory.setUpContext(element, baseContext);
            contexts.put(element, baseContext);
            break;
        }
        while (pathIterator.hasNext()) {
            element = pathIterator.next();
            baseContext = factory.setUpContext(element, baseContext);
            contexts.put(element, baseContext);
        }
        return new PathContext(baseContext, path, contexts);
    }

    public void destroyNotIn(PathContext path, PathContextFactory factory) {
        Iterator<Path> aElements = this.path.elements().iterator();
        Iterator<Path> bElements = path.path.elements().iterator();
        while (aElements.hasNext() && bElements.hasNext()) {
            Path bElement;
            Path aElement = aElements.next();
            if (aElement.equals(bElement = bElements.next())) continue;
            factory.tearDownContext(this.contexts.get(aElement));
            break;
        }
    }

    public static PathContext get(Context context) {
        return Preconditions.checkNotNull((PathContext)((Object)context.getSystemService(SERVICE_NAME)), "Expected to find a PathContext but did not.", new Object[0]);
    }

    public Object getSystemService(String name) {
        if (SERVICE_NAME.equals(name)) {
            return this;
        }
        return super.getSystemService(name);
    }
}

