/*
 * Decompiled with CFR 0.152.
 */
package com.example.flow;

import com.example.flow.MainActivity;
import com.example.flow.SampleData;
import com.example.flow.model.Conversation;
import com.example.flow.model.User;
import com.example.flow.view.ConversationListView;
import com.example.flow.view.ConversationView;
import com.example.flow.view.FriendListView;
import com.example.flow.view.FriendView;
import com.example.flow.view.MessageView;
import dagger.Module;
import dagger.Provides;
import flow.HasParent;
import flow.Layout;

public @interface App {

    @Layout(value=2130903044)
    @Module(injects={FriendView.class})
    public static class Friend
    implements HasParent<FriendList> {
        public final int index;

        public Friend(int index) {
            this.index = index;
        }

        @Provides
        User provideFriend() {
            return SampleData.FRIENDS.get(this.index);
        }

        public FriendList getParent() {
            return new FriendList();
        }
    }

    @Layout(value=2130903043)
    @Module(injects={FriendListView.class}, addsTo=MainActivity.ActivityModule.class)
    public static class FriendList
    implements HasParent<ConversationList> {
        public ConversationList getParent() {
            return new ConversationList();
        }
    }

    @Layout(value=2130903045)
    @Module(injects={MessageView.class}, addsTo=MainActivity.ActivityModule.class)
    public static class Message
    implements HasParent<Conversation> {
        public final int conversationIndex;
        public final int messageId;

        public Message(int conversationIndex, int messageId) {
            this.conversationIndex = conversationIndex;
            this.messageId = messageId;
        }

        @Provides
        Conversation.Item provideMessage() {
            return SampleData.CONVERSATIONS.get((int)this.conversationIndex).items.get(this.messageId);
        }

        public Conversation getParent() {
            return new Conversation(this.conversationIndex);
        }
    }

    @Layout(value=2130903042)
    @Module(injects={ConversationView.class}, addsTo=MainActivity.ActivityModule.class)
    public static class Conversation
    implements HasParent<ConversationList> {
        public final int conversationIndex;

        public Conversation(int conversationIndex) {
            this.conversationIndex = conversationIndex;
        }

        @Provides
        com.example.flow.model.Conversation provideConversation() {
            return SampleData.CONVERSATIONS.get(this.conversationIndex);
        }

        public ConversationList getParent() {
            return new ConversationList();
        }
    }

    @Layout(value=2130903041)
    @Module(injects={ConversationListView.class}, addsTo=MainActivity.ActivityModule.class)
    public static class ConversationList {
    }
}

