/*
 * Decompiled with CFR 0.152.
 */
package com.example.flow;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import flow.Parcer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class GsonParcer<T>
implements Parcer<T> {
    private final Gson gson;

    public GsonParcer(Gson gson) {
        this.gson = gson;
    }

    public Parcelable wrap(T instance) {
        try {
            String json = this.encode(instance);
            return new Wrapper(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public T unwrap(Parcelable parcelable) {
        Wrapper wrapper = (Wrapper)parcelable;
        try {
            return this.decode(wrapper.json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encode(T instance) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter writer = new JsonWriter((Writer)stringWriter);){
            Class<?> type = instance.getClass();
            writer.beginObject();
            writer.name(type.getName());
            this.gson.toJson(instance, type, writer);
            writer.endObject();
            String string = stringWriter.toString();
            return string;
        }
    }

    private T decode(String json) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)new StringReader(json));){
            reader.beginObject();
            Class<?> type = Class.forName(reader.nextName());
            Object object = this.gson.fromJson(reader, type);
            return (T)object;
        }
    }

    private static class Wrapper
    implements Parcelable {
        final String json;
        public static final Parcelable.Creator<Wrapper> CREATOR = new Parcelable.Creator<Wrapper>(){

            public Wrapper createFromParcel(Parcel in) {
                String json = in.readString();
                return new Wrapper(json);
            }

            public Wrapper[] newArray(int size) {
                return new Wrapper[size];
            }
        };

        Wrapper(String json) {
            this.json = json;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.json);
        }
    }
}

