/*
 * Decompiled with CFR 0.152.
 */
package com.example.flow;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import butterknife.ButterKnife;
import butterknife.InjectView;
import com.example.flow.App;
import com.example.flow.GsonParcer;
import com.example.flow.SampleData;
import com.example.flow.ScopedContext;
import com.example.flow.model.Conversation;
import com.example.flow.model.User;
import com.example.flow.view.ContainerView;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dagger.Module;
import dagger.ObjectGraph;
import dagger.Provides;
import flow.Backstack;
import flow.Flow;
import flow.HasParent;
import flow.Layouts;
import flow.Parcer;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

public class MainActivity
extends Activity
implements Flow.Listener {
    private static final String BUNDLE_BACKSTACK = "backstack";
    @InjectView(value=2130968576)
    ContainerView containerView;
    @Inject
    Parcer<Object> parcer;
    private Flow flow;
    private ObjectGraph activityGraph;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        ButterKnife.inject((Activity)this);
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayShowHomeEnabled(false);
        this.activityGraph = ObjectGraph.create((Object[])new Object[]{new ActivityModule()});
        this.activityGraph.inject((Object)this);
        this.flow = new Flow(this.getInitialBackstack(savedInstanceState), (Flow.Listener)this);
        this.go(this.flow.getBackstack(), Flow.Direction.FORWARD);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(BUNDLE_BACKSTACK, this.flow.getBackstack().getParcelable(this.parcer));
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        MenuItem friendsMenu = menu.add((CharSequence)"Friends").setShowAsActionFlags(2).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                MainActivity.this.flow.goTo((Object)new App.FriendList());
                return true;
            }
        });
        Object screen = this.flow.getBackstack().current().getScreen();
        boolean hasUp = screen instanceof HasParent;
        friendsMenu.setVisible(!hasUp);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            return this.flow.goUp();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (!this.flow.goBack()) {
            this.finish();
        }
    }

    public void go(Backstack backstack, Flow.Direction direction) {
        Object screen = backstack.current().getScreen();
        this.containerView.displayView(this.getView(screen), direction);
        this.setTitle(screen.getClass().getSimpleName());
        ActionBar actionBar = this.getActionBar();
        boolean hasUp = screen instanceof HasParent;
        actionBar.setDisplayHomeAsUpEnabled(hasUp);
        actionBar.setHomeButtonEnabled(hasUp);
        this.invalidateOptionsMenu();
    }

    private Backstack getInitialBackstack(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            return Backstack.from((Parcelable)savedInstanceState.getParcelable(BUNDLE_BACKSTACK), this.parcer);
        }
        return Backstack.single((Object)new App.ConversationList());
    }

    private View getView(Object screen) {
        ObjectGraph graph = this.activityGraph.plus(new Object[]{screen});
        ScopedContext scopedContext = new ScopedContext((Context)this, graph);
        return Layouts.createView((Context)scopedContext, (Object)screen);
    }

    @Module(injects={MainActivity.class}, library=true)
    class ActivityModule {
        ActivityModule() {
        }

        @Provides
        @App
        Flow provideAppFlow() {
            return MainActivity.this.flow;
        }

        @Provides
        List<Conversation> provideConversations() {
            return SampleData.CONVERSATIONS;
        }

        @Provides
        List<User> provideFriends() {
            return SampleData.FRIENDS;
        }

        @Provides
        @Singleton
        Gson provideGson() {
            return new GsonBuilder().create();
        }

        @Provides
        @Singleton
        Parcer<Object> provideParcer(Gson gson) {
            return new GsonParcer<Object>(gson);
        }
    }
}

