/*
 * Decompiled with CFR 0.152.
 */
package com.example.flow.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.example.flow.Utils;
import flow.Flow;

public class ContainerView
extends FrameLayout {
    private boolean disabled;
    private View activeView;

    public ContainerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return !this.disabled && super.dispatchTouchEvent(ev);
    }

    public void displayView(View view, final Flow.Direction direction) {
        this.addView(view);
        if (this.activeView != null) {
            final View from = this.activeView;
            final View to = view;
            Utils.waitForMeasure(to, new Utils.OnMeasuredCallback(){

                @Override
                public void onMeasured(View view, int width, int height) {
                    ContainerView.this.runAnimation(from, to, direction);
                }
            });
        }
        this.activeView = view;
    }

    private void runAnimation(final View from, View to, Flow.Direction direction) {
        this.disabled = true;
        Animator animator = this.createSegue(from, to, direction);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ContainerView.this.removeView(from);
                ContainerView.this.disabled = false;
            }
        });
        animator.start();
    }

    private Animator createSegue(View from, View to, Flow.Direction direction) {
        boolean backward = direction == Flow.Direction.BACKWARD;
        int fromTranslation = backward ? from.getWidth() : -from.getWidth();
        int toTranslation = backward ? -to.getWidth() : to.getWidth();
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)ObjectAnimator.ofFloat((Object)from, (Property)View.TRANSLATION_X, (float[])new float[]{fromTranslation}));
        set.play((Animator)ObjectAnimator.ofFloat((Object)to, (Property)View.TRANSLATION_X, (float[])new float[]{toTranslation, 0.0f}));
        return set;
    }
}

