/*
 * Decompiled with CFR 0.152.
 */
package com.example.flow.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.example.flow.App;
import com.example.flow.Utils;
import com.example.flow.model.Conversation;
import flow.Flow;
import java.util.List;
import javax.inject.Inject;

public class ConversationView
extends ListView {
    @Inject
    @App
    Flow flow;
    @Inject
    Conversation conversation;
    @Inject
    List<Conversation> conversationList;

    public ConversationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Utils.inject(context, (View)this);
        this.setConversation(this.conversation);
    }

    private void setConversation(final Conversation conversation) {
        Adapter adapter = new Adapter(this.getContext(), conversation.items);
        this.setAdapter((ListAdapter)adapter);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int conversationIndex = ConversationView.this.conversationList.indexOf(conversation);
                ConversationView.this.flow.goTo((Object)new App.Message(conversationIndex, position));
            }
        });
    }

    private static class Adapter
    extends ArrayAdapter<Conversation.Item> {
        public Adapter(Context context, List<Conversation.Item> objects) {
            super(context, 17367043, objects);
        }
    }
}

