/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.LeakReference;
import leakcanary.LeakTrace;
import leakcanary.LeakTraceElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\t\n\u0002\b \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 62\u00020\u0001:\u00016B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u000eH\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c6\u0003J\t\u0010+\u001a\u00020\u000eH\u00c6\u0003Js\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u000201H\u00d6\u0001J\n\u00102\u001a\u000603j\u0002`4J\t\u00105\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013\u00a8\u00067"}, d2={"Lleakcanary/AnalysisResult;", "Ljava/io/Serializable;", "referenceKey", "", "referenceName", "leakFound", "", "excludedLeak", "className", "leakTrace", "Lleakcanary/LeakTrace;", "failure", "", "retainedHeapSize", "", "analysisDurationMs", "watchDurationMs", "(Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/String;Lleakcanary/LeakTrace;Ljava/lang/Throwable;JJJ)V", "getAnalysisDurationMs", "()J", "getClassName", "()Ljava/lang/String;", "getExcludedLeak", "()Z", "getFailure", "()Ljava/lang/Throwable;", "getLeakFound", "getLeakTrace", "()Lleakcanary/LeakTrace;", "getReferenceKey", "getReferenceName", "getRetainedHeapSize", "getWatchDurationMs", "classSimpleName", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "leakTraceAsFakeException", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "toString", "Companion", "leakcanary-analyzer-core"})
public final class AnalysisResult
implements Serializable {
    @NotNull
    private final String referenceKey;
    @NotNull
    private final String referenceName;
    private final boolean leakFound;
    private final boolean excludedLeak;
    @Nullable
    private final String className;
    @Nullable
    private final LeakTrace leakTrace;
    @Nullable
    private final Throwable failure;
    private final long retainedHeapSize;
    private final long analysisDurationMs;
    private final long watchDurationMs;
    public static final long RETAINED_HEAP_SKIPPED = -1L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RuntimeException leakTraceAsFakeException() {
        Iterable $receiver$iv;
        Iterable iterable;
        if (!this.leakFound) {
            throw (Throwable)new UnsupportedOperationException("leakTraceAsFakeException() can only be called when leakFound is true");
        }
        LeakTrace leakTrace = this.leakTrace;
        if (leakTrace == null) {
            Intrinsics.throwNpe();
        }
        LeakTraceElement firstElement = leakTrace.getElements().get(0);
        String rootSimpleName = this.classSimpleName(firstElement.getClassName());
        String string = this.className;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String leakSimpleName = this.classSimpleName(string);
        StringBuilder stringBuilder = new StringBuilder().append(leakSimpleName).append(" leak from ").append(rootSimpleName).append(" (holder=").append((Object)firstElement.getHolder()).append(", type= ");
        LeakReference leakReference = firstElement.getReference();
        if (leakReference == null) {
            Intrinsics.throwNpe();
        }
        RuntimeException runtimeException = new RuntimeException(stringBuilder.append((Object)leakReference.getType()).append(')').toString());
        List stackTrace = new ArrayList();
        Iterable $receiver$iv2 = iterable = ($receiver$iv = (Iterable)this.leakTrace.getElements());
        for (Object element$iv : $receiver$iv2) {
            LeakTraceElement element = (LeakTraceElement)element$iv;
            boolean bl = false;
            String methodName = element.getReference() != null ? element.getReference().getName() : "leaking";
            String file = this.classSimpleName(element.getClassName()) + ".java";
            stackTrace.add(new StackTraceElement(element.getClassName(), methodName, file, 42));
        }
        $receiver$iv = stackTrace;
        RuntimeException runtimeException2 = runtimeException;
        Iterable thisCollection$iv = $receiver$iv;
        StackTraceElement[] stackTraceElementArray = thisCollection$iv.toArray(new StackTraceElement[0]);
        if (stackTraceElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        runtimeException2.setStackTrace(stackTraceElementArray2);
        return runtimeException;
    }

    private final String classSimpleName(String className) {
        String string;
        int separator = StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (separator == -1) {
            string = className;
        } else {
            String string2 = className;
            int n = separator + 1;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @NotNull
    public final String getReferenceKey() {
        return this.referenceKey;
    }

    @NotNull
    public final String getReferenceName() {
        return this.referenceName;
    }

    public final boolean getLeakFound() {
        return this.leakFound;
    }

    public final boolean getExcludedLeak() {
        return this.excludedLeak;
    }

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    @Nullable
    public final LeakTrace getLeakTrace() {
        return this.leakTrace;
    }

    @Nullable
    public final Throwable getFailure() {
        return this.failure;
    }

    public final long getRetainedHeapSize() {
        return this.retainedHeapSize;
    }

    public final long getAnalysisDurationMs() {
        return this.analysisDurationMs;
    }

    public final long getWatchDurationMs() {
        return this.watchDurationMs;
    }

    public AnalysisResult(@NotNull String referenceKey, @NotNull String referenceName, boolean leakFound, boolean excludedLeak, @Nullable String className, @Nullable LeakTrace leakTrace, @Nullable Throwable failure, long retainedHeapSize, long analysisDurationMs, long watchDurationMs) {
        Intrinsics.checkParameterIsNotNull((Object)referenceKey, (String)"referenceKey");
        Intrinsics.checkParameterIsNotNull((Object)referenceName, (String)"referenceName");
        this.referenceKey = referenceKey;
        this.referenceName = referenceName;
        this.leakFound = leakFound;
        this.excludedLeak = excludedLeak;
        this.className = className;
        this.leakTrace = leakTrace;
        this.failure = failure;
        this.retainedHeapSize = retainedHeapSize;
        this.analysisDurationMs = analysisDurationMs;
        this.watchDurationMs = watchDurationMs;
    }

    public /* synthetic */ AnalysisResult(String string, String string2, boolean bl, boolean bl2, String string3, LeakTrace leakTrace, Throwable throwable, long l, long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            leakTrace = null;
        }
        if ((n & 0x40) != 0) {
            throwable = null;
        }
        this(string, string2, bl, bl2, string3, leakTrace, throwable, l, l2, l3);
    }

    @NotNull
    public final String component1() {
        return this.referenceKey;
    }

    @NotNull
    public final String component2() {
        return this.referenceName;
    }

    public final boolean component3() {
        return this.leakFound;
    }

    public final boolean component4() {
        return this.excludedLeak;
    }

    @Nullable
    public final String component5() {
        return this.className;
    }

    @Nullable
    public final LeakTrace component6() {
        return this.leakTrace;
    }

    @Nullable
    public final Throwable component7() {
        return this.failure;
    }

    public final long component8() {
        return this.retainedHeapSize;
    }

    public final long component9() {
        return this.analysisDurationMs;
    }

    public final long component10() {
        return this.watchDurationMs;
    }

    @NotNull
    public final AnalysisResult copy(@NotNull String referenceKey, @NotNull String referenceName, boolean leakFound, boolean excludedLeak, @Nullable String className, @Nullable LeakTrace leakTrace, @Nullable Throwable failure, long retainedHeapSize, long analysisDurationMs, long watchDurationMs) {
        Intrinsics.checkParameterIsNotNull((Object)referenceKey, (String)"referenceKey");
        Intrinsics.checkParameterIsNotNull((Object)referenceName, (String)"referenceName");
        return new AnalysisResult(referenceKey, referenceName, leakFound, excludedLeak, className, leakTrace, failure, retainedHeapSize, analysisDurationMs, watchDurationMs);
    }

    @NotNull
    public static /* synthetic */ AnalysisResult copy$default(AnalysisResult analysisResult, String string, String string2, boolean bl, boolean bl2, String string3, LeakTrace leakTrace, Throwable throwable, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            string = analysisResult.referenceKey;
        }
        if ((n & 2) != 0) {
            string2 = analysisResult.referenceName;
        }
        if ((n & 4) != 0) {
            bl = analysisResult.leakFound;
        }
        if ((n & 8) != 0) {
            bl2 = analysisResult.excludedLeak;
        }
        if ((n & 0x10) != 0) {
            string3 = analysisResult.className;
        }
        if ((n & 0x20) != 0) {
            leakTrace = analysisResult.leakTrace;
        }
        if ((n & 0x40) != 0) {
            throwable = analysisResult.failure;
        }
        if ((n & 0x80) != 0) {
            l = analysisResult.retainedHeapSize;
        }
        if ((n & 0x100) != 0) {
            l2 = analysisResult.analysisDurationMs;
        }
        if ((n & 0x200) != 0) {
            l3 = analysisResult.watchDurationMs;
        }
        return analysisResult.copy(string, string2, bl, bl2, string3, leakTrace, throwable, l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "AnalysisResult(referenceKey=" + this.referenceKey + ", referenceName=" + this.referenceName + ", leakFound=" + this.leakFound + ", excludedLeak=" + this.excludedLeak + ", className=" + this.className + ", leakTrace=" + this.leakTrace + ", failure=" + this.failure + ", retainedHeapSize=" + this.retainedHeapSize + ", analysisDurationMs=" + this.analysisDurationMs + ", watchDurationMs=" + this.watchDurationMs + ")";
    }

    public int hashCode() {
        String string = this.referenceKey;
        String string2 = this.referenceName;
        int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
        int n2 = this.leakFound ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        int n3 = (n + n2) * 31;
        int n4 = this.excludedLeak ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        String string3 = this.className;
        LeakTrace leakTrace = this.leakTrace;
        Throwable throwable = this.failure;
        long l = this.retainedHeapSize;
        long l2 = this.analysisDurationMs;
        long l3 = this.watchDurationMs;
        return ((((((n3 + n4) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (leakTrace != null ? ((Object)leakTrace).hashCode() : 0)) * 31 + (throwable != null ? throwable.hashCode() : 0)) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AnalysisResult)) break block3;
                AnalysisResult analysisResult = (AnalysisResult)object;
                if (!Intrinsics.areEqual((Object)this.referenceKey, (Object)analysisResult.referenceKey) || !Intrinsics.areEqual((Object)this.referenceName, (Object)analysisResult.referenceName) || !(this.leakFound == analysisResult.leakFound) || !(this.excludedLeak == analysisResult.excludedLeak) || !Intrinsics.areEqual((Object)this.className, (Object)analysisResult.className) || !Intrinsics.areEqual((Object)this.leakTrace, (Object)analysisResult.leakTrace) || !Intrinsics.areEqual((Object)this.failure, (Object)analysisResult.failure) || !(this.retainedHeapSize == analysisResult.retainedHeapSize) || !(this.analysisDurationMs == analysisResult.analysisDurationMs) || !(this.watchDurationMs == analysisResult.watchDurationMs)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004JH\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lleakcanary/AnalysisResult$Companion;", "", "()V", "RETAINED_HEAP_SKIPPED", "", "failure", "Lleakcanary/AnalysisResult;", "", "analysisDurationMs", "leakDetected", "referenceKey", "", "referenceName", "excludedLeak", "", "className", "leakTrace", "Lleakcanary/LeakTrace;", "retainedHeapSize", "watchDurationMs", "noLeak", "leakcanary-analyzer-core"})
    public static final class Companion {
        @NotNull
        public final AnalysisResult noLeak(@NotNull String className, long analysisDurationMs) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            return new AnalysisResult("Fake-" + UUID.randomUUID(), "", false, false, className, null, null, 0L, analysisDurationMs, 0L);
        }

        @NotNull
        public final AnalysisResult leakDetected(@NotNull String referenceKey, @NotNull String referenceName, boolean excludedLeak, @NotNull String className, @Nullable LeakTrace leakTrace, long retainedHeapSize, long analysisDurationMs, long watchDurationMs) {
            Intrinsics.checkParameterIsNotNull((Object)referenceKey, (String)"referenceKey");
            Intrinsics.checkParameterIsNotNull((Object)referenceName, (String)"referenceName");
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            return new AnalysisResult(referenceKey, referenceName, true, excludedLeak, className, leakTrace, null, retainedHeapSize, analysisDurationMs, watchDurationMs);
        }

        @NotNull
        public final AnalysisResult failure(@NotNull Throwable failure, long analysisDurationMs) {
            Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
            return new AnalysisResult("Fake-" + UUID.randomUUID(), "", false, false, null, null, failure, 0L, analysisDurationMs, 0L);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

