/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.CanaryLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lleakcanary/Serializables;", "", "()V", "fromByteArray", "T", "byteArray", "", "([B)Ljava/lang/Object;", "load", "file", "Ljava/io/File;", "(Ljava/io/File;)Ljava/lang/Object;", "leakcanary-analyzer-core"})
public final class Serializables {
    public static final Serializables INSTANCE;

    @Nullable
    public final <T> T fromByteArray(@NotNull byte[] byteArray) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        try {
            object = new ObjectInputStream(inputStream).readObject();
        }
        catch (Throwable ignored) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T load(@NotNull File file) {
        Closeable closeable;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            closeable = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        FileInputStream fileInputStream = closeable;
        closeable = fileInputStream;
        Throwable throwable = null;
        try {
            Object object;
            Closeable it = closeable;
            boolean bl = false;
            try {
                ObjectInputStream inputStream = new ObjectInputStream((InputStream)it);
                object = inputStream.readObject();
            }
            catch (Exception e) {
                CanaryLog.INSTANCE.d((Throwable)e, "Could not read file %s", new Object[]{file});
                object = null;
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private Serializables() {
    }

    static {
        Serializables serializables;
        INSTANCE = serializables = new Serializables();
    }
}

