/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import leakcanary.CanaryLog;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u00a8\u0006\u0007"}, d2={"save", "", "Ljava/io/Serializable;", "file", "Ljava/io/File;", "toByteArray", "", "leakcanary-analyzer-core"})
public final class SerializablesKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean save(@NotNull Serializable $receiver, @NotNull File file) {
        Closeable closeable;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            closeable = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        FileOutputStream fileOutputStream = closeable;
        closeable = fileOutputStream;
        Throwable throwable = null;
        try {
            boolean bl;
            Closeable it = closeable;
            boolean bl2 = false;
            try {
                ObjectOutputStream outputStream = new ObjectOutputStream((OutputStream)it);
                outputStream.writeObject($receiver);
                bl = true;
            }
            catch (IOException e) {
                CanaryLog.INSTANCE.d((Throwable)e, "Could not save leak analysis result to disk.", new Object[0]);
                bl = false;
            }
            boolean bl3 = bl;
            return bl3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull Serializable $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new ObjectOutputStream(outputStream).writeObject($receiver);
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }
}

