/*
 * Decompiled with CFR 0.152.
 */
package leakcanary.internal;

import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import leakcanary.LeakTrace;
import leakcanary.LeakTraceElement;
import leakcanary.Reachability;
import leakcanary.internal.LeakTraceRendererKt$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0006\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"ELEMENT_DEFAULT_NEW_LINE_SPACE", "", "ZERO_WIDTH_SPACE", "", "getNextElementString", "leakTrace", "Lleakcanary/LeakTrace;", "element", "Lleakcanary/LeakTraceElement;", "index", "", "renderToString", "Lleakcanary/Reachability;", "leakcanary-analyzer-core"})
public final class LeakTraceRendererKt {
    private static final char ZERO_WIDTH_SPACE = '\u200b';
    private static final String ELEMENT_DEFAULT_NEW_LINE_SPACE = "     ";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderToString(@NotNull LeakTrace $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String leakInfo = "\u252c\n";
        LeakTraceElement lastElement = (LeakTraceElement)CollectionsKt.last($receiver.getElements());
        Reachability lastReachability = (Reachability)CollectionsKt.last($receiver.getExpectedReachability());
        Iterable iterable = CollectionsKt.dropLast($receiver.getElements(), (int)1);
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void leakTraceElement;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            LeakTraceElement leakTraceElement2 = (LeakTraceElement)item$iv;
            int index = n2;
            boolean bl = false;
            Reachability currentReachability = $receiver.getExpectedReachability().get(index);
            Collection collection = leakTraceElement.getLabels();
            StringBuilder stringBuilder = new StringBuilder().append("\n        #\u251c\u2500 ").append(leakTraceElement.getClassName()).append("\n        #\u2502    Leaking: ").append(LeakTraceRendererKt.renderToString(currentReachability));
            StringBuilder stringBuilder2 = new StringBuilder().append(leakInfo);
            boolean bl2 = !collection.isEmpty();
            leakInfo = stringBuilder2.append(StringsKt.trimMargin((String)stringBuilder.append(bl2 ? CollectionsKt.joinToString$default((Iterable)leakTraceElement.getLabels(), (CharSequence)"\n\u2502    ", (CharSequence)"\n\u2502    ", null, (int)0, null, null, (int)60, null) : "").append("\n        #\u2502    \u2193 ").append(LeakTraceRendererKt.getNextElementString($receiver, (LeakTraceElement)leakTraceElement, index)).append("\n        #").toString(), (String)"#")).toString();
        }
        leakInfo = leakInfo + StringsKt.trimMargin((String)("\u2570\u2192 " + lastElement.getClassName() + "\n      #\u200b     Leaking: " + LeakTraceRendererKt.renderToString(lastReachability) + "\n    "), (String)"#");
        return leakInfo;
    }

    private static final String renderToString(@NotNull Reachability $receiver) {
        String string;
        switch (LeakTraceRendererKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getStatus().ordinal()]) {
            case 1: {
                string = "UNKNOWN";
                break;
            }
            case 2: {
                string = "NO (" + $receiver.getReason() + ')';
                break;
            }
            case 3: {
                string = "YES (" + $receiver.getReason() + ')';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String getNextElementString(LeakTrace leakTrace, LeakTraceElement element, int index) {
        String string;
        String staticString;
        boolean maybeLeakCause = leakTrace.elementMayBeLeakCause(index);
        String string2 = staticString = element.getReference() != null && element.getReference().getType() == LeakTraceElement.Type.STATIC_FIELD ? "static " : "";
        if (element.getHolder() == LeakTraceElement.Holder.ARRAY || element.getHolder() == LeakTraceElement.Holder.THREAD) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = element.getHolder().name();
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            StringBuilder stringBuilder2 = stringBuilder;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            String string6 = string5;
            string = stringBuilder2.append(string6).append(' ').toString();
        } else {
            string = "";
        }
        String holderString = string;
        String simpleClassName = element.getSimpleClassName();
        String referenceName = element.getReference() != null ? '.' + element.getReference().getDisplayName() : "";
        String exclusionString = element.getExclusion() != null ? " , matching exclusion " + element.getExclusion().getMatching() : "";
        int requiredSpaces = staticString.length() + holderString.length() + simpleClassName.length() + "\u251c\u2500".length();
        String leakString = maybeLeakCause ? "\n\u2502     " + StringsKt.repeat((CharSequence)" ", (int)requiredSpaces) + StringsKt.repeat((CharSequence)"~", (int)(referenceName.length() - 1)) : "";
        return staticString + holderString + simpleClassName + referenceName + exclusionString + leakString;
    }
}

