/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.Preconditions;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class ExcludedRefs {
    final Map<String, Set<String>> excludeFieldMap = new LinkedHashMap<String, Set<String>>();
    final Map<String, Set<String>> excludeStaticFieldMap = new LinkedHashMap<String, Set<String>>();
    final Set<String> excludedThreads = new LinkedHashSet<String>();

    public void instanceField(String className, String fieldName) {
        Preconditions.checkNotNull((Object)className, (String)"className");
        Preconditions.checkNotNull((Object)fieldName, (String)"fieldName");
        Set<String> excludedFields = this.excludeFieldMap.get(className);
        if (excludedFields == null) {
            excludedFields = new LinkedHashSet<String>();
            this.excludeFieldMap.put(className, excludedFields);
        }
        excludedFields.add(fieldName);
    }

    public void staticField(String className, String fieldName) {
        Preconditions.checkNotNull((Object)className, (String)"className");
        Preconditions.checkNotNull((Object)fieldName, (String)"fieldName");
        Set<String> excludedFields = this.excludeStaticFieldMap.get(className);
        if (excludedFields == null) {
            excludedFields = new LinkedHashSet<String>();
            this.excludeStaticFieldMap.put(className, excludedFields);
        }
        excludedFields.add(fieldName);
    }

    public void thread(String threadName) {
        Preconditions.checkNotNull((Object)threadName, (String)"threadName");
        this.excludedThreads.add(threadName);
    }
}

