/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.KeyedWeakReference;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.SnapshotFactory;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.PathsFromGCRootsTree;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.PrettyPrinter;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

public final class HeapAnalyzer {
    private static final String ANONYMOUS_CLASS_NAME_PATTERN = "^.+\\$\\d+$";
    private final ExcludedRefs baseExcludedRefs;
    private final ExcludedRefs excludedRefs;

    public HeapAnalyzer(ExcludedRefs excludedRefs) {
        this(new ExcludedRefs(), excludedRefs);
    }

    public HeapAnalyzer(ExcludedRefs baseExcludedRefs, ExcludedRefs excludedRefs) {
        this.baseExcludedRefs = baseExcludedRefs;
        this.excludedRefs = excludedRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult checkForLeak(File heapDumpFile, String referenceKey) {
        long analysisStartNanoTime = System.nanoTime();
        if (!heapDumpFile.exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDumpFile);
            return AnalysisResult.failure(exception, this.since(analysisStartNanoTime));
        }
        ISnapshot snapshot = null;
        try {
            snapshot = this.openSnapshot(heapDumpFile);
            IObject leakingRef = this.findLeakingReference(referenceKey, snapshot);
            if (leakingRef == null) {
                AnalysisResult analysisResult = AnalysisResult.noLeak(this.since(analysisStartNanoTime));
                return analysisResult;
            }
            String className = leakingRef.getClazz().getName();
            AnalysisResult result = this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef, className, true);
            if (!result.leakFound) {
                result = this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef, className, false);
            }
            AnalysisResult analysisResult = result;
            return analysisResult;
        }
        catch (SnapshotException e) {
            AnalysisResult analysisResult = AnalysisResult.failure((Exception)((Object)e), this.since(analysisStartNanoTime));
            return analysisResult;
        }
        finally {
            this.cleanup(heapDumpFile, snapshot);
        }
    }

    private AnalysisResult findLeakTrace(long analysisStartNanoTime, ISnapshot snapshot, IObject leakingRef, String className, boolean excludingKnownLeaks) throws SnapshotException {
        ExcludedRefs excludedRefs = excludingKnownLeaks ? this.excludedRefs : this.baseExcludedRefs;
        PathsFromGCRootsTree gcRootsTree = this.shortestPathToGcRoots(snapshot, leakingRef, excludedRefs);
        if (gcRootsTree == null) {
            return AnalysisResult.noLeak(this.since(analysisStartNanoTime));
        }
        LeakTrace leakTrace = this.buildLeakTrace(snapshot, gcRootsTree, excludedRefs);
        return AnalysisResult.leakDetected(!excludingKnownLeaks, className, leakTrace, this.since(analysisStartNanoTime));
    }

    private ISnapshot openSnapshot(File heapDumpFile) throws SnapshotException {
        SnapshotFactory factory = new SnapshotFactory();
        Map args = Collections.emptyMap();
        VoidProgressListener listener = new VoidProgressListener();
        return factory.openSnapshot(heapDumpFile, args, (IProgressListener)listener);
    }

    private IObject findLeakingReference(String key, ISnapshot snapshot) throws SnapshotException {
        int[] weakRefInstanceIds;
        Collection refClasses = snapshot.getClassesByName(KeyedWeakReference.class.getName(), false);
        if (refClasses.size() != 1) {
            throw new IllegalStateException("Expecting one class for " + KeyedWeakReference.class.getName() + " in " + refClasses);
        }
        IClass refClass = (IClass)refClasses.iterator().next();
        for (int weakRefInstanceId : weakRefInstanceIds = refClass.getObjectIds()) {
            IObject weakRef = snapshot.getObject(weakRefInstanceId);
            String keyCandidate = PrettyPrinter.objectAsString((IObject)((IObject)weakRef.resolveValue("key")), (int)100);
            if (!keyCandidate.equals(key)) continue;
            return (IObject)weakRef.resolveValue("referent");
        }
        throw new IllegalStateException("Could not find weak reference with key " + key);
    }

    private PathsFromGCRootsTree shortestPathToGcRoots(ISnapshot snapshot, IObject leakingRef, ExcludedRefs excludedRefs) throws SnapshotException {
        Map<IClass, Set<String>> excludeMap = this.buildClassExcludeMap(snapshot, excludedRefs.excludeFieldMap);
        IPathsFromGCRootsComputer pathComputer = snapshot.getPathsFromGCRoots(leakingRef.getObjectId(), excludeMap);
        return this.shortestValidPath(snapshot, pathComputer, excludedRefs);
    }

    private Map<IClass, Set<String>> buildClassExcludeMap(ISnapshot snapshot, Map<String, Set<String>> excludeMap) throws SnapshotException {
        LinkedHashMap<IClass, Set<String>> classExcludeMap = new LinkedHashMap<IClass, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : excludeMap.entrySet()) {
            Collection refClasses = snapshot.getClassesByName(entry.getKey(), false);
            if (refClasses == null || refClasses.size() != 1) continue;
            IClass refClass = (IClass)refClasses.iterator().next();
            classExcludeMap.put(refClass, entry.getValue());
        }
        return classExcludeMap;
    }

    private PathsFromGCRootsTree shortestValidPath(ISnapshot snapshot, IPathsFromGCRootsComputer pathComputer, ExcludedRefs excludedRefs) throws SnapshotException {
        int[] shortestPath;
        Map<IClass, Set<String>> excludedStaticFields = this.buildClassExcludeMap(snapshot, excludedRefs.excludeStaticFieldMap);
        while ((shortestPath = pathComputer.getNextShortestPath()) != null) {
            PathsFromGCRootsTree tree = pathComputer.getTree(Collections.singletonList(shortestPath));
            if (!this.validPath(snapshot, tree, excludedStaticFields, excludedRefs)) continue;
            return tree;
        }
        return null;
    }

    private boolean validPath(ISnapshot snapshot, PathsFromGCRootsTree tree, Map<IClass, Set<String>> excludedStaticFields, ExcludedRefs excludedRefs) throws SnapshotException {
        if (excludedStaticFields.isEmpty() && excludedRefs.excludedThreads.isEmpty()) {
            return true;
        }
        IObject parent = null;
        while (tree != null) {
            NamedReference ref;
            IClass childClass;
            Set<String> childClassExcludedFields;
            IObject child = snapshot.getObject(tree.getOwnId());
            if (child instanceof IClass ? (childClassExcludedFields = excludedStaticFields.get(childClass = (IClass)child)) != null && (ref = this.findChildInParent(parent, child, excludedRefs)) != null && childClassExcludedFields.contains(ref.getName()) : child.getClazz().doesExtend(Thread.class.getName()) && excludedRefs.excludedThreads.contains(this.getThreadName(child))) {
                return false;
            }
            parent = child;
            int[] branchIds = tree.getObjectIds();
            tree = branchIds.length > 0 ? tree.getBranch(branchIds[0]) : null;
        }
        return true;
    }

    private String getThreadName(IObject thread) throws SnapshotException {
        return PrettyPrinter.objectAsString((IObject)((IObject)thread.resolveValue("name")), (int)Integer.MAX_VALUE);
    }

    private NamedReference findChildInParent(IObject parent, IObject child, ExcludedRefs excludedRefs) throws SnapshotException {
        if (parent == null) {
            return null;
        }
        Set<String> excludedFields = excludedRefs.excludeFieldMap.get(child.getClazz().getName());
        for (NamedReference childRef : child.getOutboundReferences()) {
            if (childRef.getObjectId() != parent.getObjectId() || excludedFields != null && excludedFields.contains(childRef.getName())) continue;
            return childRef;
        }
        return null;
    }

    private LeakTrace buildLeakTrace(ISnapshot snapshot, PathsFromGCRootsTree tree, ExcludedRefs excludedRefs) throws SnapshotException {
        ArrayList<LeakTraceElement> elements = new ArrayList<LeakTraceElement>();
        IObject parent = null;
        while (tree != null) {
            IObject child = snapshot.getObject(tree.getOwnId());
            elements.add(0, this.buildLeakElement(parent, child, excludedRefs));
            parent = child;
            int[] branchIds = tree.getObjectIds();
            tree = branchIds.length > 0 ? tree.getBranch(branchIds[0]) : null;
        }
        return new LeakTrace(elements);
    }

    private LeakTraceElement buildLeakElement(IObject parent, IObject child, ExcludedRefs excludedRefs) throws SnapshotException {
        String className;
        LeakTraceElement.Holder holder;
        LeakTraceElement.Type type = null;
        String referenceName = null;
        NamedReference childRef = this.findChildInParent(parent, child, excludedRefs);
        if (childRef != null) {
            referenceName = childRef.getName();
            type = child instanceof IClass ? LeakTraceElement.Type.STATIC_FIELD : (childRef instanceof ThreadToLocalReference ? LeakTraceElement.Type.LOCAL : LeakTraceElement.Type.INSTANCE_FIELD);
        }
        String extra = null;
        if (child instanceof IClass) {
            IClass clazz = (IClass)child;
            holder = LeakTraceElement.Holder.CLASS;
            className = clazz.getName();
        } else if (child instanceof IArray) {
            holder = LeakTraceElement.Holder.ARRAY;
            IClass clazz = child.getClazz();
            className = clazz.getName();
        } else {
            IClass clazz = child.getClazz();
            className = clazz.getName();
            if (clazz.doesExtend(Thread.class.getName())) {
                holder = LeakTraceElement.Holder.THREAD;
                String threadName = this.getThreadName(child);
                extra = "(named '" + threadName + "')";
            } else if (className.matches(ANONYMOUS_CLASS_NAME_PATTERN)) {
                String parentClassName = clazz.getSuperClass().getName();
                if (Object.class.getName().equals(parentClassName)) {
                    holder = LeakTraceElement.Holder.OBJECT;
                    try {
                        Class<?> actualClass = Class.forName(clazz.getName());
                        Class<?> implementedInterface = actualClass.getInterfaces()[0];
                        extra = "(anonymous class implements " + implementedInterface.getName() + ")";
                    }
                    catch (ClassNotFoundException ignored) {}
                } else {
                    holder = LeakTraceElement.Holder.OBJECT;
                    extra = "(anonymous class extends " + parentClassName + ")";
                }
            } else {
                holder = LeakTraceElement.Holder.OBJECT;
            }
        }
        return new LeakTraceElement(referenceName, type, holder, className, extra);
    }

    private void cleanup(File heapDumpFile, ISnapshot snapshot) {
        File[] toRemove;
        if (snapshot != null) {
            snapshot.dispose();
        }
        final String heapDumpFileName = heapDumpFile.getName();
        final String prefix = heapDumpFileName.substring(0, heapDumpFile.getName().length() - ".hprof".length());
        for (File file : toRemove = heapDumpFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().startsWith(prefix) && !file.getName().equals(heapDumpFileName);
            }
        })) {
            file.delete();
        }
    }

    private long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }
}

