/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import java.io.Serializable;
import java.util.Locale;

public final class LeakTraceElement
implements Serializable {
    public final String referenceName;
    public final Type type;
    public final Holder holder;
    public final String className;
    public final String extra;

    LeakTraceElement(String referenceName, Type type, Holder holder, String className, String extra) {
        this.referenceName = referenceName;
        this.type = type;
        this.holder = holder;
        this.className = className;
        this.extra = extra;
    }

    public String toString() {
        String string = "";
        if (this.type == Type.STATIC_FIELD) {
            string = string + "static ";
        }
        if (this.holder == Holder.ARRAY || this.holder == Holder.THREAD) {
            string = string + this.holder.name().toLowerCase(Locale.US) + " ";
        }
        string = string + this.className;
        string = this.referenceName != null ? string + "." + this.referenceName : string + " instance";
        if (this.extra != null) {
            string = string + " " + this.extra;
        }
        return string;
    }

    public static enum Holder {
        OBJECT,
        CLASS,
        THREAD,
        ARRAY;

    }

    public static enum Type {
        INSTANCE_FIELD,
        STATIC_FIELD,
        LOCAL;

    }
}

