/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.leakcanary.LeakTrace;
import java.io.Serializable;

public final class AnalysisResult
implements Serializable {
    public final boolean leakFound;
    public final boolean excludedLeak;
    public final String className;
    public final LeakTrace leakTrace;
    public final Throwable failure;
    public final long retainedHeapSize;
    public final long analysisDurationMs;

    public static AnalysisResult noLeak(long analysisDurationMs) {
        return new AnalysisResult(false, false, null, null, null, 0L, analysisDurationMs);
    }

    public static AnalysisResult leakDetected(boolean excludedLeak, String className, LeakTrace leakTrace, long retainedHeapSize, long analysisDurationMs) {
        return new AnalysisResult(true, excludedLeak, className, leakTrace, null, retainedHeapSize, analysisDurationMs);
    }

    public static AnalysisResult failure(Throwable failure, long analysisDurationMs) {
        return new AnalysisResult(false, false, null, null, failure, 0L, analysisDurationMs);
    }

    private AnalysisResult(boolean leakFound, boolean excludedLeak, String className, LeakTrace leakTrace, Throwable failure, long retainedHeapSize, long analysisDurationMs) {
        this.leakFound = leakFound;
        this.excludedLeak = excludedLeak;
        this.className = className;
        this.leakTrace = leakTrace;
        this.failure = failure;
        this.retainedHeapSize = retainedHeapSize;
        this.analysisDurationMs = analysisDurationMs;
    }
}

