/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.haha.perflib.ArrayInstance;
import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.HprofParser;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.RootType;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.perflib.Type;
import com.squareup.haha.perflib.io.HprofBuffer;
import com.squareup.haha.perflib.io.MemoryMappedFileBuffer;
import com.squareup.haha.trove.THashMap;
import com.squareup.haha.trove.TObjectProcedure;
import com.squareup.leakcanary.AnalysisResult;
import com.squareup.leakcanary.ExcludedRefs;
import com.squareup.leakcanary.HahaHelper;
import com.squareup.leakcanary.KeyedWeakReference;
import com.squareup.leakcanary.LeakNode;
import com.squareup.leakcanary.LeakTrace;
import com.squareup.leakcanary.LeakTraceElement;
import com.squareup.leakcanary.ShortestPathFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class HeapAnalyzer {
    private static final String ANONYMOUS_CLASS_NAME_PATTERN = "^.+\\$\\d+$";
    private final ExcludedRefs excludedRefs;

    public HeapAnalyzer(ExcludedRefs excludedRefs) {
        this.excludedRefs = excludedRefs;
    }

    public AnalysisResult checkForLeak(File heapDumpFile, String referenceKey) {
        long analysisStartNanoTime = System.nanoTime();
        if (!heapDumpFile.exists()) {
            IllegalArgumentException exception = new IllegalArgumentException("File does not exist: " + heapDumpFile);
            return AnalysisResult.failure(exception, this.since(analysisStartNanoTime));
        }
        try {
            MemoryMappedFileBuffer buffer = new MemoryMappedFileBuffer(heapDumpFile);
            HprofParser parser = new HprofParser((HprofBuffer)buffer);
            Snapshot snapshot = parser.parse();
            this.deduplicateGcRoots(snapshot);
            Instance leakingRef = this.findLeakingReference(referenceKey, snapshot);
            if (leakingRef == null) {
                return AnalysisResult.noLeak(this.since(analysisStartNanoTime));
            }
            return this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef);
        }
        catch (Throwable e) {
            return AnalysisResult.failure(e, this.since(analysisStartNanoTime));
        }
    }

    void deduplicateGcRoots(Snapshot snapshot) {
        final THashMap uniqueRootMap = new THashMap();
        final ArrayList gcRoots = (ArrayList)snapshot.getGCRoots();
        for (RootObj root : gcRoots) {
            String key = this.generateRootKey(root);
            if (uniqueRootMap.containsKey((Object)key)) continue;
            uniqueRootMap.put((Object)key, (Object)root);
        }
        gcRoots.clear();
        uniqueRootMap.forEach((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String key) {
                return gcRoots.add(uniqueRootMap.get((Object)key));
            }
        });
    }

    private String generateRootKey(RootObj root) {
        return String.format("%s@0x%08x", root.getRootType().getName(), root.getId());
    }

    private Instance findLeakingReference(String key, Snapshot snapshot) {
        ClassObj refClass = snapshot.findClass(KeyedWeakReference.class.getName());
        ArrayList<String> keysFound = new ArrayList<String>();
        for (Instance instance : refClass.getInstancesList()) {
            List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(instance);
            String keyCandidate = HahaHelper.asString(HahaHelper.fieldValue(values, "key"));
            if (keyCandidate.equals(key)) {
                return (Instance)HahaHelper.fieldValue(values, "referent");
            }
            keysFound.add(keyCandidate);
        }
        throw new IllegalStateException("Could not find weak reference with key " + key + " in " + keysFound);
    }

    private AnalysisResult findLeakTrace(long analysisStartNanoTime, Snapshot snapshot, Instance leakingRef) {
        ShortestPathFinder pathFinder = new ShortestPathFinder(this.excludedRefs);
        ShortestPathFinder.Result result = pathFinder.findPath(snapshot, leakingRef);
        if (result.leakingNode == null) {
            return AnalysisResult.noLeak(this.since(analysisStartNanoTime));
        }
        LeakTrace leakTrace = this.buildLeakTrace(result.leakingNode);
        String className = leakingRef.getClassObj().getClassName();
        snapshot.computeDominators();
        Instance leakingInstance = result.leakingNode.instance;
        long retainedSize = leakingInstance.getTotalRetainedSize();
        return AnalysisResult.leakDetected(result.excludingKnownLeaks, className, leakTrace, retainedSize += (long)this.computeIgnoredBitmapRetainedSize(snapshot, leakingInstance), this.since(analysisStartNanoTime));
    }

    private int computeIgnoredBitmapRetainedSize(Snapshot snapshot, Instance leakingInstance) {
        int bitmapRetainedSize = 0;
        ClassObj bitmapClass = snapshot.findClass("android.graphics.Bitmap");
        for (Instance bitmapInstance : bitmapClass.getInstancesList()) {
            ArrayInstance mBufferInstance;
            if (!this.isIgnoredDominator(leakingInstance, bitmapInstance) || (mBufferInstance = (ArrayInstance)HahaHelper.fieldValue(HahaHelper.classInstanceValues(bitmapInstance), "mBuffer")) == null) continue;
            long bufferSize = mBufferInstance.getTotalRetainedSize();
            long bitmapSize = bitmapInstance.getTotalRetainedSize();
            if (bitmapSize < bufferSize) {
                bitmapSize += bufferSize;
            }
            bitmapRetainedSize = (int)((long)bitmapRetainedSize + bitmapSize);
        }
        return bitmapRetainedSize;
    }

    private boolean isIgnoredDominator(Instance dominator, Instance instance) {
        boolean foundNativeRoot = false;
        do {
            Instance immediateDominator;
            if ((immediateDominator = instance.getImmediateDominator()) instanceof RootObj && ((RootObj)immediateDominator).getRootType() == RootType.UNKNOWN) {
                instance = instance.getNextInstanceToGcRoot();
                foundNativeRoot = true;
            } else {
                instance = immediateDominator;
            }
            if (instance != null) continue;
            return false;
        } while (instance != dominator);
        return foundNativeRoot;
    }

    private LeakTrace buildLeakTrace(LeakNode leakingNode) {
        ArrayList<LeakTraceElement> elements = new ArrayList<LeakTraceElement>();
        LeakNode node = new LeakNode(null, null, leakingNode, null, null);
        while (node != null) {
            LeakTraceElement element = this.buildLeakElement(node);
            if (element != null) {
                elements.add(0, element);
            }
            node = node.parent;
        }
        return new LeakTrace(elements);
    }

    private LeakTraceElement buildLeakElement(LeakNode node) {
        String className;
        LeakTraceElement.Holder holderType;
        ArrayList<String> fields;
        String extra;
        String referenceName;
        LeakTraceElement.Type type;
        block20: {
            if (node.parent == null) {
                return null;
            }
            Instance holder = node.parent.instance;
            if (holder instanceof RootObj) {
                return null;
            }
            type = node.referenceType;
            referenceName = node.referenceName;
            extra = null;
            fields = new ArrayList<String>();
            if (holder instanceof ClassObj) {
                ClassObj classObj = (ClassObj)holder;
                holderType = LeakTraceElement.Holder.CLASS;
                className = classObj.getClassName();
                for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
                    Field field = (Field)entry.getKey();
                    Object value = entry.getValue();
                    fields.add("static " + field.getName() + " = " + value);
                }
            } else if (holder instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)holder;
                holderType = LeakTraceElement.Holder.ARRAY;
                className = arrayInstance.getClassObj().getClassName();
                if (arrayInstance.getArrayType() == Type.OBJECT) {
                    Object[] values = arrayInstance.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        fields.add("[" + i + "] = " + values[i]);
                    }
                }
            } else {
                ClassInstance classInstance = (ClassInstance)holder;
                ClassObj classObj = holder.getClassObj();
                for (Map.Entry<Field, Object> entry : classObj.getStaticFieldValues().entrySet()) {
                    fields.add("static " + HahaHelper.fieldToString(entry));
                }
                for (ClassInstance.FieldValue fieldValue : classInstance.getValues()) {
                    fields.add(HahaHelper.fieldToString(fieldValue));
                }
                className = classObj.getClassName();
                if (HahaHelper.extendsThread(classObj)) {
                    holderType = LeakTraceElement.Holder.THREAD;
                    String threadName = HahaHelper.threadName(holder);
                    extra = "(named '" + threadName + "')";
                } else if (className.matches(ANONYMOUS_CLASS_NAME_PATTERN)) {
                    String parentClassName = classObj.getSuperClassObj().getClassName();
                    if (Object.class.getName().equals(parentClassName)) {
                        holderType = LeakTraceElement.Holder.OBJECT;
                        try {
                            Class<?> clazz = Class.forName(classObj.getClassName());
                            Class<?>[] interfaces = clazz.getInterfaces();
                            if (interfaces.length > 0) {
                                Class<?> implementedInterface = interfaces[0];
                                extra = "(anonymous implementation of " + implementedInterface.getName() + ")";
                                break block20;
                            }
                            extra = "(anonymous subclass of java.lang.Object)";
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    } else {
                        holderType = LeakTraceElement.Holder.OBJECT;
                        extra = "(anonymous subclass of " + parentClassName + ")";
                    }
                } else {
                    holderType = LeakTraceElement.Holder.OBJECT;
                }
            }
        }
        return new LeakTraceElement(referenceName, type, holderType, className, extra, node.exclusion, fields);
    }

    private long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }
}

