/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.leakcanary;

import com.squareup.haha.perflib.ArrayInstance;
import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.Heap;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.Type;
import com.squareup.leakcanary.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HahaHelper {
    private static final Set<String> WRAPPER_TYPES = new HashSet<String>(Arrays.asList(Boolean.class.getName(), Character.class.getName(), Float.class.getName(), Double.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName()));

    static String fieldToString(Map.Entry<Field, Object> entry) {
        return HahaHelper.fieldToString(entry.getKey(), entry.getValue());
    }

    static String fieldToString(ClassInstance.FieldValue fieldValue) {
        return HahaHelper.fieldToString(fieldValue.getField(), fieldValue.getValue());
    }

    static String fieldToString(Field field, Object value) {
        return field.getName() + " = " + value;
    }

    static String threadName(Instance holder) {
        List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(holder);
        Object nameField = HahaHelper.fieldValue(values, "name");
        if (nameField == null) {
            return "Thread name not available";
        }
        return HahaHelper.asString(nameField);
    }

    static boolean extendsThread(ClassObj clazz) {
        boolean extendsThread = false;
        ClassObj parentClass = clazz;
        while (parentClass.getSuperClassObj() != null) {
            if (clazz.getClassName().equals(Thread.class.getName())) {
                extendsThread = true;
                break;
            }
            parentClass = parentClass.getSuperClassObj();
        }
        return extendsThread;
    }

    static String asString(Object stringObject) {
        Integer offset;
        ArrayInstance charArray;
        Instance instance = (Instance)stringObject;
        List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(instance);
        Integer count = (Integer)HahaHelper.fieldValue(values, "count");
        Object value = HahaHelper.fieldValue(values, "value");
        if (HahaHelper.isCharArray(value)) {
            charArray = (ArrayInstance)value;
            offset = 0;
            if (HahaHelper.hasField(values, "offset")) {
                offset = (Integer)HahaHelper.fieldValue(values, "offset");
            }
        } else {
            Heap heap = instance.getHeap();
            Instance inlineInstance = heap.getInstance(instance.getId() + 16L);
            if (HahaHelper.isCharArray(inlineInstance)) {
                charArray = (ArrayInstance)inlineInstance;
                offset = 0;
            } else {
                throw new UnsupportedOperationException("Could not find char array in " + instance);
            }
        }
        Preconditions.checkNotNull((Object)count, (String)"count");
        Preconditions.checkNotNull((Object)charArray, (String)"charArray");
        Preconditions.checkNotNull((Object)offset, (String)"offset");
        if (count == 0) {
            return "";
        }
        char[] chars = charArray.asCharArray(offset.intValue(), count.intValue());
        return new String(chars);
    }

    public static boolean isPrimitiveWrapper(Object value) {
        if (!(value instanceof ClassInstance)) {
            return false;
        }
        return WRAPPER_TYPES.contains(((ClassInstance)value).getClassObj().getClassName());
    }

    public static boolean isPrimitiveOrWrapperArray(Object value) {
        if (!(value instanceof ArrayInstance)) {
            return false;
        }
        ArrayInstance arrayInstance = (ArrayInstance)value;
        if (arrayInstance.getArrayType() != Type.OBJECT) {
            return true;
        }
        return WRAPPER_TYPES.contains(arrayInstance.getClassObj().getClassName());
    }

    private static boolean isCharArray(Object value) {
        return value instanceof ArrayInstance && ((ArrayInstance)value).getArrayType() == Type.CHAR;
    }

    static List<ClassInstance.FieldValue> classInstanceValues(Instance instance) {
        ClassInstance classInstance = (ClassInstance)instance;
        return classInstance.getValues();
    }

    static <T> T fieldValue(List<ClassInstance.FieldValue> values, String fieldName) {
        for (ClassInstance.FieldValue fieldValue : values) {
            if (!fieldValue.getField().getName().equals(fieldName)) continue;
            return (T)fieldValue.getValue();
        }
        throw new IllegalArgumentException("Field " + fieldName + " does not exists");
    }

    static boolean hasField(List<ClassInstance.FieldValue> values, String fieldName) {
        for (ClassInstance.FieldValue fieldValue : values) {
            if (!fieldValue.getField().getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private HahaHelper() {
        throw new AssertionError();
    }
}

