/*
 * Decompiled with CFR 0.152.
 */
package leakcanary;

import java.io.Closeable;
import java.io.File;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import leakcanary.HeapDumpFileProvider;
import leakcanary.HeapDumpStorageStrategy;
import leakcanary.HeapDumper;
import org.jetbrains.annotations.NotNull;
import shark.CloseableHeapGraph;
import shark.HeapDiff;
import shark.HeapGraph;
import shark.HeapTraversalInput;
import shark.HeapTraversalOutput;
import shark.HprofHeapGraph;
import shark.InitialState;
import shark.ObjectGrowthDetector;
import shark.RepeatingScenarioObjectGrowthDetector;
import shark.SharkLog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J&\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lleakcanary/DumpingRepeatingScenarioObjectGrowthDetector;", "Lshark/RepeatingScenarioObjectGrowthDetector;", "objectGrowthDetector", "Lshark/ObjectGrowthDetector;", "heapDumpFileProvider", "Lleakcanary/HeapDumpFileProvider;", "heapDumper", "Lleakcanary/HeapDumper;", "heapDumpStorageStrategy", "Lleakcanary/HeapDumpStorageStrategy;", "(Lshark/ObjectGrowthDetector;Lleakcanary/HeapDumpFileProvider;Lleakcanary/HeapDumper;Lleakcanary/HeapDumpStorageStrategy;)V", "findRepeatedlyGrowingObjects", "Lshark/HeapDiff;", "maxHeapDumps", "", "scenarioLoopsPerDump", "roundTripScenario", "Lkotlin/Function0;", "", "findRepeatedlyGrowingObjectsInner", "findGrowingObjects", "Lshark/HeapTraversalOutput;", "Ljava/io/File;", "previousTraversal", "Lshark/HeapTraversalInput;", "leakcanary-core"})
@SourceDebugExtension(value={"SMAP\nDumpingRepeatingScenarioObjectGrowthDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpingRepeatingScenarioObjectGrowthDetector.kt\nleakcanary/DumpingRepeatingScenarioObjectGrowthDetector\n+ 2 SharkLog.kt\nshark/SharkLog\n*L\n1#1,93:1\n34#2,3:94\n*S KotlinDebug\n*F\n+ 1 DumpingRepeatingScenarioObjectGrowthDetector.kt\nleakcanary/DumpingRepeatingScenarioObjectGrowthDetector\n*L\n67#1:94,3\n*E\n"})
public final class DumpingRepeatingScenarioObjectGrowthDetector
implements RepeatingScenarioObjectGrowthDetector {
    @NotNull
    private final ObjectGrowthDetector objectGrowthDetector;
    @NotNull
    private final HeapDumpFileProvider heapDumpFileProvider;
    @NotNull
    private final HeapDumper heapDumper;
    @NotNull
    private final HeapDumpStorageStrategy heapDumpStorageStrategy;

    public DumpingRepeatingScenarioObjectGrowthDetector(@NotNull ObjectGrowthDetector objectGrowthDetector, @NotNull HeapDumpFileProvider heapDumpFileProvider, @NotNull HeapDumper heapDumper, @NotNull HeapDumpStorageStrategy heapDumpStorageStrategy) {
        Intrinsics.checkNotNullParameter((Object)objectGrowthDetector, (String)"objectGrowthDetector");
        Intrinsics.checkNotNullParameter((Object)heapDumpFileProvider, (String)"heapDumpFileProvider");
        Intrinsics.checkNotNullParameter((Object)heapDumper, (String)"heapDumper");
        Intrinsics.checkNotNullParameter((Object)heapDumpStorageStrategy, (String)"heapDumpStorageStrategy");
        this.objectGrowthDetector = objectGrowthDetector;
        this.heapDumpFileProvider = heapDumpFileProvider;
        this.heapDumper = heapDumper;
        this.heapDumpStorageStrategy = heapDumpStorageStrategy;
    }

    @NotNull
    public HeapDiff findRepeatedlyGrowingObjects(int maxHeapDumps, int scenarioLoopsPerDump, @NotNull Function0<Unit> roundTripScenario) {
        HeapDiff heapDiff;
        Intrinsics.checkNotNullParameter(roundTripScenario, (String)"roundTripScenario");
        try {
            heapDiff = this.findRepeatedlyGrowingObjectsInner(scenarioLoopsPerDump, maxHeapDumps, roundTripScenario);
        }
        catch (Throwable exception) {
            this.heapDumpStorageStrategy.onHeapDiffResult(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exception)));
            throw exception;
        }
        HeapDiff heapDiff2 = heapDiff;
        this.heapDumpStorageStrategy.onHeapDiffResult(Result.constructor-impl((Object)heapDiff2));
        return heapDiff2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeapDiff findRepeatedlyGrowingObjectsInner(int scenarioLoopsPerDump, int maxHeapDumps, Function0<Unit> roundTripScenario) {
        InitialState lastTraversalOutput = null;
        lastTraversalOutput = new InitialState(scenarioLoopsPerDump);
        int i = 1;
        if (i <= maxHeapDumps) {
            while (true) {
                HeapTraversalInput it2;
                int n = 0;
                while (n < scenarioLoopsPerDump) {
                    int it2 = n++;
                    boolean bl = false;
                    roundTripScenario.invoke();
                }
                File heapDumpFile = this.heapDumpFileProvider.newHeapDumpFile();
                this.heapDumper.dumpHeap(heapDumpFile);
                if (!heapDumpFile.exists()) {
                    boolean $i$a$-check-DumpingRepeatingScenarioObjectGrowthDetector$findRepeatedlyGrowingObjectsInner$32 = false;
                    String $i$a$-check-DumpingRepeatingScenarioObjectGrowthDetector$findRepeatedlyGrowingObjectsInner$32 = "Expected file to exist after heap dump: " + heapDumpFile.getAbsolutePath();
                    throw new IllegalStateException($i$a$-check-DumpingRepeatingScenarioObjectGrowthDetector$findRepeatedlyGrowingObjectsInner$32.toString());
                }
                this.heapDumpStorageStrategy.onHeapDumped(heapDumpFile);
                try {
                    it2 = (HeapTraversalInput)this.findGrowingObjects(heapDumpFile, (HeapTraversalInput)lastTraversalOutput);
                }
                finally {
                    this.heapDumpStorageStrategy.onHeapDumpClosed(heapDumpFile);
                }
                lastTraversalOutput = it2;
                if (lastTraversalOutput instanceof HeapDiff) {
                    if (!((HeapDiff)lastTraversalOutput).isGrowing()) {
                        return (HeapDiff)lastTraversalOutput;
                    }
                    if (i < maxHeapDumps) {
                        SharkLog this_$iv = SharkLog.INSTANCE;
                        boolean $i$f$d = false;
                        if (this_$iv.getLogger() != null) {
                            SharkLog.Logger logger$iv;
                            SharkLog.Logger logger = logger$iv;
                            boolean bl = false;
                            logger.d("After " + lastTraversalOutput.getTraversalCount() + " heap dumps with " + scenarioLoopsPerDump + " scenario iterations before each, " + ((HeapDiff)lastTraversalOutput).getGrowingObjects().size() + " growing nodes:\n" + ((HeapDiff)lastTraversalOutput).getGrowingObjects());
                        }
                    }
                }
                if (i == maxHeapDumps) break;
                ++i;
            }
        }
        if (!(lastTraversalOutput instanceof HeapDiff)) {
            boolean bl = false;
            String string = "Final output should be a HeapGrowth, traversalCount " + (((HeapTraversalInput)lastTraversalOutput).getTraversalCount() - 1) + " should be >= 2. Output: " + lastTraversalOutput;
            throw new IllegalStateException(string.toString());
        }
        return (HeapDiff)lastTraversalOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HeapTraversalOutput findGrowingObjects(File $this$findGrowingObjects, HeapTraversalInput previousTraversal) {
        HeapTraversalOutput heapTraversalOutput;
        Closeable closeable = (Closeable)HprofHeapGraph.Companion.openHeapGraph$default((HprofHeapGraph.Companion)HprofHeapGraph.Companion, (File)$this$findGrowingObjects, null, null, (int)3, null);
        Throwable throwable = null;
        try {
            CloseableHeapGraph heapGraph = (CloseableHeapGraph)closeable;
            boolean bl = false;
            heapTraversalOutput = this.objectGrowthDetector.findGrowingObjects((HeapGraph)heapGraph, previousTraversal);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return heapTraversalOutput;
    }
}

