/*
 * Decompiled with CFR 0.152.
 */
package shark.internal.hppc;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.internal.hppc.HHPC;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J%\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0005J\u0018\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00028\u00000&0%J\u0018\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010!\u001a\u00020\u001dH\u0086\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001dH\u0002J%\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u000b2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0014H\u0002\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020\u0018J\u0015\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u0010!\u001a\u00020\u001d\u00a2\u0006\u0002\u0010(J \u00100\u001a\u0004\u0018\u00018\u00002\u0006\u0010!\u001a\u00020\u001d2\u0006\u00101\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0014X\u0082\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u0012\u0004\b\u0015\u0010\u0003\u00a8\u00065"}, d2={"Lshark/internal/hppc/LongObjectScatterMap;", "T", "", "()V", "assigned", "", "hasEmptyKey", "", "isEmpty", "()Z", "keys", "", "loadFactor", "", "mask", "resizeAt", "size", "getSize", "()I", "values", "", "values$annotations", "[Ljava/lang/Object;", "allocateBuffers", "", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "", "pendingValue", "(IJLjava/lang/Object;)V", "containsKey", "key", "ensureCapacity", "expectedElements", "entrySequence", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "get", "(J)Ljava/lang/Object;", "hashKey", "rehash", "fromKeys", "fromValues", "([J[Ljava/lang/Object;)V", "release", "remove", "set", "value", "(JLjava/lang/Object;)Ljava/lang/Object;", "shiftConflictingKeys", "gapSlotArg", "shark-graph"})
public final class LongObjectScatterMap<T> {
    private long[] keys = new long[0];
    private T[] values;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private double loadFactor;

    private static /* synthetic */ void values$annotations() {
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Nullable
    public final T set(long key, T value) {
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = true;
            T previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                T previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return null;
    }

    @Nullable
    public final T remove(long key) {
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = false;
            T previousValue = this.values[mask + 1];
            this.values[mask + 1] = null;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                T previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return null;
    }

    @Nullable
    public final T get(long key) {
        if (key == 0L) {
            return this.hasEmptyKey ? (T)this.values[this.mask + 1] : null;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<Pair<Long, T>> entrySequence() {
        void slot;
        int max = this.mask + 1;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        return SequencesKt.generateSequence((Function0)new Function0<Pair<? extends Long, ? extends T>>(this, (Ref.IntRef)slot, max){
            final /* synthetic */ LongObjectScatterMap this$0;
            final /* synthetic */ Ref.IntRef $slot;
            final /* synthetic */ int $max;

            @Nullable
            public final Pair<Long, T> invoke() {
                if (this.$slot.element < this.$max) {
                    long existing = 0L;
                    int n = this.$slot.element;
                    this.$slot.element = n + 1;
                    while (this.$slot.element < this.$max) {
                        existing = LongObjectScatterMap.access$getKeys$p(this.this$0)[this.$slot.element];
                        if (existing != 0L) {
                            Long l = existing;
                            Object object = LongObjectScatterMap.access$getValues$p(this.this$0)[this.$slot.element];
                            if (object == null) {
                                Intrinsics.throwNpe();
                            }
                            return TuplesKt.to((Object)l, (Object)object);
                        }
                        n = this.$slot.element;
                        this.$slot.element = n + 1;
                    }
                }
                if (this.$slot.element == this.$max && LongObjectScatterMap.access$getHasEmptyKey$p(this.this$0)) {
                    int n = this.$slot.element;
                    this.$slot.element = n + 1;
                    Long l = 0L;
                    Object object = LongObjectScatterMap.access$getValues$p(this.this$0)[this.$max];
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    return TuplesKt.to((Object)l, (Object)object);
                }
                return null;
            }
            {
                this.this$0 = longObjectScatterMap;
                this.$slot = intRef;
                this.$max = n;
                super(0);
            }
        });
    }

    public final boolean containsKey(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return false;
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.allocateBuffers(HHPC.INSTANCE.minBufferSize(4, this.loadFactor));
    }

    public final int getSize() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt) {
            long[] prevKeys = this.keys;
            T[] prevValues = this.values;
            this.allocateBuffers(HHPC.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (!this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    private final int hashKey(long key) {
        return HHPC.INSTANCE.mixPhi(key);
    }

    private final void rehash(long[] fromKeys, T[] fromValues) {
        long[] keys = this.keys;
        T[] values = this.values;
        int mask = this.mask;
        long existing = 0L;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            existing = fromKeys[from];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    private final void allocateBuffers(int arraySize) {
        long[] prevKeys = this.keys;
        T[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            String string = "Not enough memory to allocate buffers for rehashing: %,d -> %,d";
            Object[] objectArray = new Object[]{this.mask + 1, arraySize};
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            Throwable throwable = e;
            String string4 = string3;
            throw (Throwable)new RuntimeException(string4, throwable);
        }
        this.resizeAt = HHPC.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    private final void allocateThenInsertThenRehash(int slot, long pendingKey, T pendingValue) {
        long[] prevKeys = this.keys;
        T[] prevValues = this.values;
        this.allocateBuffers(HHPC.INSTANCE.nextBufferSize(this.mask + 1, this.getSize(), this.loadFactor));
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    private final void shiftConflictingKeys(int gapSlotArg) {
        int slot;
        long existing;
        int gapSlot = gapSlotArg;
        long[] keys = this.keys;
        T[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values[gapSlot] = null;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    public LongObjectScatterMap() {
        LongObjectScatterMap longObjectScatterMap = this;
        Object[] objectArray = new Object[]{};
        longObjectScatterMap.values = objectArray;
        this.loadFactor = 0.75;
        this.ensureCapacity(4);
    }

    public static final /* synthetic */ long[] access$getKeys$p(LongObjectScatterMap $this) {
        return $this.keys;
    }

    public static final /* synthetic */ void access$setKeys$p(LongObjectScatterMap $this, long[] lArray) {
        $this.keys = lArray;
    }

    public static final /* synthetic */ Object[] access$getValues$p(LongObjectScatterMap $this) {
        return $this.values;
    }

    public static final /* synthetic */ void access$setValues$p(LongObjectScatterMap $this, Object[] objectArray) {
        $this.values = objectArray;
    }

    public static final /* synthetic */ boolean access$getHasEmptyKey$p(LongObjectScatterMap $this) {
        return $this.hasEmptyKey;
    }

    public static final /* synthetic */ void access$setHasEmptyKey$p(LongObjectScatterMap $this, boolean bl) {
        $this.hasEmptyKey = bl;
    }
}

