/*
 * Decompiled with CFR 0.152.
 */
package shark.internal.hppc;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import shark.internal.hppc.HHPC;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0011\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0011\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0006\u0010\u001d\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lshark/internal/hppc/LongScatterSet;", "", "()V", "assigned", "", "hasEmptyKey", "", "keys", "", "loadFactor", "", "mask", "resizeAt", "add", "key", "", "allocateBuffers", "", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "contains", "ensureCapacity", "expectedElements", "hashKey", "plusAssign", "rehash", "fromKeys", "release", "size", "shark-graph"})
public final class LongScatterSet {
    private long[] keys = new long[0];
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private final double loadFactor = 0.75;

    private final int hashKey(long key) {
        return HHPC.INSTANCE.mixPhi(key);
    }

    public final void plusAssign(long key) {
        this.add(key);
    }

    public final boolean add(long key) {
        if (key == 0L) {
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return true;
    }

    public final boolean contains(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return false;
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.allocateBuffers(HHPC.INSTANCE.minBufferSize(4, this.loadFactor));
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt) {
            long[] prevKeys = this.keys;
            this.allocateBuffers(HHPC.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (this.size() != 0) {
                this.rehash(prevKeys);
            }
        }
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    private final void rehash(long[] fromKeys) {
        long[] keys = this.keys;
        int mask = this.mask;
        long existing = 0L;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            existing = fromKeys[i];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    private final void allocateBuffers(int arraySize) {
        long[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            String string = "Not enough memory to allocate buffers for rehashing: %,d -> %,d";
            Object[] objectArray = new Object[]{this.size(), arraySize};
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            Throwable throwable = e;
            String string4 = string3;
            throw (Throwable)new RuntimeException(string4, throwable);
        }
        this.resizeAt = HHPC.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    private final void allocateThenInsertThenRehash(int slot, long pendingKey) {
        long[] prevKeys = this.keys;
        this.allocateBuffers(HHPC.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    public LongScatterSet() {
        this.ensureCapacity(4);
    }
}

