/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shark.HprofRecord;
import shark.PrimitiveType;
import shark.ValueHolder;
import shark.internal.IndexedObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H\u0002J\b\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lshark/internal/ClassFieldsReader;", "", "identifierByteSize", "", "classFieldBytes", "", "(I[B)V", "position", "classDumpFields", "", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$FieldRecord;", "indexedClass", "Lshark/internal/IndexedObject$IndexedClass;", "classDumpHasReferenceFields", "", "classDumpStaticFields", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$StaticFieldRecord;", "readBoolean", "readByte", "", "readChar", "", "readDouble", "", "readFloat", "", "readId", "", "readInt", "readLong", "readShort", "", "readUnsignedByte", "readUnsignedShort", "readValue", "Lshark/ValueHolder;", "type", "skipStaticFields", "", "Companion", "shark-graph"})
public final class ClassFieldsReader {
    private int position;
    private final int identifierByteSize;
    private final byte[] classFieldBytes;
    private static final int BOOLEAN_TYPE;
    private static final int CHAR_TYPE;
    private static final int FLOAT_TYPE;
    private static final int DOUBLE_TYPE;
    private static final int BYTE_TYPE;
    private static final int SHORT_TYPE;
    private static final int INT_TYPE;
    private static final int LONG_TYPE;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord> classDumpStaticFields(@NotNull IndexedObject.IndexedClass indexedClass) {
        Intrinsics.checkParameterIsNotNull((Object)indexedClass, (String)"indexedClass");
        this.position = indexedClass.getFieldsIndex();
        int staticFieldCount = this.readUnsignedShort();
        ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord> staticFields = new ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord>(staticFieldCount);
        int n = 0;
        int n2 = staticFieldCount;
        while (n < n2) {
            void i;
            long nameStringId = this.readId();
            int type = this.readUnsignedByte();
            ValueHolder value = this.readValue(type);
            staticFields.add(new HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord(nameStringId, type, value));
            ++i;
        }
        return staticFields;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord> classDumpFields(@NotNull IndexedObject.IndexedClass indexedClass) {
        Intrinsics.checkParameterIsNotNull((Object)indexedClass, (String)"indexedClass");
        this.position = indexedClass.getFieldsIndex();
        this.skipStaticFields();
        int fieldCount = this.readUnsignedShort();
        ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord> fields = new ArrayList<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord>(fieldCount);
        int n = 0;
        int n2 = fieldCount;
        while (n < n2) {
            void i;
            fields.add(new HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord(this.readId(), this.readUnsignedByte()));
            ++i;
        }
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean classDumpHasReferenceFields(@NotNull IndexedObject.IndexedClass indexedClass) {
        Intrinsics.checkParameterIsNotNull((Object)indexedClass, (String)"indexedClass");
        this.position = indexedClass.getFieldsIndex();
        this.skipStaticFields();
        int fieldCount = this.readUnsignedShort();
        int n = 0;
        int n2 = fieldCount;
        while (n < n2) {
            void i;
            this.position += this.identifierByteSize;
            int type = this.readUnsignedByte();
            if (type == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void skipStaticFields() {
        int staticFieldCount = this.readUnsignedShort();
        int n = 0;
        int n2 = staticFieldCount;
        while (n < n2) {
            void i;
            this.position += this.identifierByteSize;
            int type = this.readUnsignedByte();
            this.position += type == 2 ? this.identifierByteSize : ((Number)MapsKt.getValue((Map)PrimitiveType.Companion.getByteSizeByHprofType(), (Object)type)).intValue();
            ++i;
        }
    }

    private final ValueHolder readValue(int type) {
        ValueHolder valueHolder;
        int n = type;
        if (n == 2) {
            valueHolder = (ValueHolder)new ValueHolder.ReferenceHolder(this.readId());
        } else if (n == BOOLEAN_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.BooleanHolder(this.readBoolean());
        } else if (n == CHAR_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.CharHolder(this.readChar());
        } else if (n == FLOAT_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.FloatHolder(this.readFloat());
        } else if (n == DOUBLE_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.DoubleHolder(this.readDouble());
        } else if (n == BYTE_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.ByteHolder(this.readByte());
        } else if (n == SHORT_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.ShortHolder(this.readShort());
        } else if (n == INT_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.IntHolder(this.readInt());
        } else if (n == LONG_TYPE) {
            valueHolder = (ValueHolder)new ValueHolder.LongHolder(this.readLong());
        } else {
            throw (Throwable)new IllegalStateException("Unknown type " + type);
        }
        return valueHolder;
    }

    private final byte readByte() {
        int n = this.position;
        this.position = n + 1;
        return this.classFieldBytes[n];
    }

    private final int readInt() {
        int n = this.position;
        this.position = n + 1;
        int n2 = (this.classFieldBytes[n] & 0xFF) << 24;
        n = this.position;
        this.position = n + 1;
        int n3 = n2 | (this.classFieldBytes[n] & 0xFF) << 16;
        n = this.position;
        this.position = n + 1;
        int n4 = n3 | (this.classFieldBytes[n] & 0xFF) << 8;
        n = this.position;
        this.position = n + 1;
        return n4 | this.classFieldBytes[n] & 0xFF;
    }

    private final long readLong() {
        int n = this.position;
        this.position = n + 1;
        long l = ((long)this.classFieldBytes[n] & 0xFFL) << 56;
        n = this.position;
        this.position = n + 1;
        long l2 = l | ((long)this.classFieldBytes[n] & 0xFFL) << 48;
        n = this.position;
        this.position = n + 1;
        long l3 = l2 | ((long)this.classFieldBytes[n] & 0xFFL) << 40;
        n = this.position;
        this.position = n + 1;
        long l4 = l3 | ((long)this.classFieldBytes[n] & 0xFFL) << 32;
        n = this.position;
        this.position = n + 1;
        long l5 = l4 | ((long)this.classFieldBytes[n] & 0xFFL) << 24;
        n = this.position;
        this.position = n + 1;
        long l6 = l5 | ((long)this.classFieldBytes[n] & 0xFFL) << 16;
        n = this.position;
        this.position = n + 1;
        long l7 = l6 | ((long)this.classFieldBytes[n] & 0xFFL) << 8;
        n = this.position;
        this.position = n + 1;
        return l7 | (long)this.classFieldBytes[n] & 0xFFL;
    }

    private final short readShort() {
        int n = this.position;
        this.position = n + 1;
        int n2 = (this.classFieldBytes[n] & 0xFF) << 8;
        n = this.position;
        this.position = n + 1;
        return (short)(n2 | this.classFieldBytes[n] & 0xFF);
    }

    private final int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    private final int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    private final long readId() {
        long l;
        switch (this.identifierByteSize) {
            case 1: {
                l = this.readByte();
                break;
            }
            case 2: {
                l = this.readShort();
                break;
            }
            case 4: {
                l = this.readInt();
                break;
            }
            case 8: {
                l = this.readLong();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("ID Length must be 1, 2, 4, or 8");
            }
        }
        return l;
    }

    private final boolean readBoolean() {
        return this.readByte() != 0;
    }

    private final char readChar() {
        return (char)this.readShort();
    }

    private final float readFloat() {
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = this.readInt();
        boolean bl = false;
        return Float.intBitsToFloat(n);
    }

    private final double readDouble() {
        DoubleCompanionObject doubleCompanionObject = DoubleCompanionObject.INSTANCE;
        long l = this.readLong();
        boolean bl = false;
        return Double.longBitsToDouble(l);
    }

    public ClassFieldsReader(int identifierByteSize, @NotNull byte[] classFieldBytes) {
        Intrinsics.checkParameterIsNotNull((Object)classFieldBytes, (String)"classFieldBytes");
        this.identifierByteSize = identifierByteSize;
        this.classFieldBytes = classFieldBytes;
    }

    static {
        Companion = new Companion(null);
        BOOLEAN_TYPE = PrimitiveType.BOOLEAN.getHprofType();
        CHAR_TYPE = PrimitiveType.CHAR.getHprofType();
        FLOAT_TYPE = PrimitiveType.FLOAT.getHprofType();
        DOUBLE_TYPE = PrimitiveType.DOUBLE.getHprofType();
        BYTE_TYPE = PrimitiveType.BYTE.getHprofType();
        SHORT_TYPE = PrimitiveType.SHORT.getHprofType();
        INT_TYPE = PrimitiveType.INT.getHprofType();
        LONG_TYPE = PrimitiveType.LONG.getHprofType();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lshark/internal/ClassFieldsReader$Companion;", "", "()V", "BOOLEAN_TYPE", "", "BYTE_TYPE", "CHAR_TYPE", "DOUBLE_TYPE", "FLOAT_TYPE", "INT_TYPE", "LONG_TYPE", "SHORT_TYPE", "shark-graph"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

