/*
 * Decompiled with CFR 0.152.
 */
package shark.internal;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u0004\u0018\u00018\u00012\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\f\u00a8\u0006!"}, d2={"Lshark/internal/LruCache;", "K", "V", "", "maxSize", "", "(I)V", "cache", "Ljava/util/LinkedHashMap;", "<set-?>", "evictionCount", "getEvictionCount", "()I", "hitCount", "getHitCount", "getMaxSize", "missCount", "getMissCount", "putCount", "getPutCount", "size", "getSize", "evictAll", "", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "toString", "", "shark-graph"})
public final class LruCache<K, V> {
    private final LinkedHashMap<K, V> cache;
    private int putCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;
    private final int maxSize;

    public final int getSize() {
        return this.cache.size();
    }

    public final int getPutCount() {
        return this.putCount;
    }

    public final int getEvictionCount() {
        return this.evictionCount;
    }

    public final int getHitCount() {
        return this.hitCount;
    }

    public final int getMissCount() {
        return this.missCount;
    }

    @Nullable
    public final V get(@Nullable K key) {
        Object v;
        Map map = this.cache;
        boolean bl = false;
        Object value = map.get(key);
        if (value != null) {
            int n = this.hitCount;
            this.hitCount = n + 1;
            v = value;
        } else {
            int n = this.missCount;
            this.missCount = n + 1;
            v = null;
        }
        return v;
    }

    @Nullable
    public final V put(K key, V value) {
        int n = this.putCount;
        this.putCount = n + 1;
        return this.cache.put(key, value);
    }

    @Nullable
    public final V remove(K key) {
        return this.cache.remove(key);
    }

    public final void evictAll() {
        this.cache.clear();
    }

    @NotNull
    public String toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]";
        Object[] objectArray = new Object[]{this.maxSize, this.hitCount, this.missCount, hitPercent};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public LruCache(int maxSize) {
        this.maxSize = maxSize;
        boolean bl = this.maxSize > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "maxSize=" + this.maxSize + " <= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.cache = new LinkedHashMap<K, V>(this.maxSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(@Nullable Map.Entry<K, V> eldest) {
                boolean bl;
                if (this.size() > this.getMaxSize()) {
                    LruCache lruCache = this;
                    int n = lruCache.getEvictionCount();
                    lruCache.evictionCount = n + 1;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        };
    }

    public static final /* synthetic */ int access$getEvictionCount$p(LruCache $this) {
        return $this.evictionCount;
    }
}

