/*
 * Decompiled with CFR 0.152.
 */
package shark.internal.hppc;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import shark.internal.hppc.HHPC;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0011\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0006\u0010\u001d\u001a\u00020\u0012J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0006\u0010!\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lshark/internal/hppc/LongScatterSet;", "", "expectedElements", "", "(I)V", "assigned", "hasEmptyKey", "", "keys", "", "loadFactor", "", "mask", "resizeAt", "add", "key", "", "allocateBuffers", "", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "contains", "ensureCapacity", "hashKey", "plusAssign", "rehash", "fromKeys", "release", "remove", "shiftConflictingKeys", "inputGapSlot", "size", "shark-graph"})
public final class LongScatterSet {
    private long[] keys;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private final double loadFactor;

    private final int hashKey(long key) {
        return HHPC.INSTANCE.mixPhi(key);
    }

    public final void plusAssign(long key) {
        this.add(key);
    }

    public final boolean add(long key) {
        if (key == 0L) {
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return true;
    }

    public final boolean contains(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return false;
    }

    public final boolean remove(long key) {
        boolean bl;
        if (key == 0L) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            bl = hadEmptyKey;
        } else {
            long[] keys = this.keys;
            int mask = this.mask;
            int slot = this.hashKey(key) & mask;
            long existing = keys[slot];
            while (existing != 0L) {
                if (existing == key) {
                    this.shiftConflictingKeys(slot);
                    return true;
                }
                slot = slot + 1 & mask;
                existing = keys[slot];
            }
            bl = false;
        }
        return bl;
    }

    private final void shiftConflictingKeys(int inputGapSlot) {
        int slot;
        long existing;
        int gapSlot = inputGapSlot;
        long[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.allocateBuffers(HHPC.INSTANCE.minBufferSize(4, this.loadFactor));
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt) {
            long[] prevKeys = this.keys;
            this.allocateBuffers(HHPC.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (this.size() != 0) {
                this.rehash(prevKeys);
            }
        }
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    private final void rehash(long[] fromKeys) {
        long[] keys = this.keys;
        int mask = this.mask;
        long existing = 0L;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            existing = fromKeys[i];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    private final void allocateBuffers(int arraySize) {
        long[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            String string = "Not enough memory to allocate buffers for rehashing: %,d -> %,d";
            Object[] objectArray = new Object[]{this.size(), arraySize};
            boolean bl = false;
            String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            throw (Throwable)new RuntimeException(string2, e);
        }
        this.resizeAt = HHPC.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    private final void allocateThenInsertThenRehash(int slot, long pendingKey) {
        long[] prevKeys = this.keys;
        this.allocateBuffers(HHPC.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    public LongScatterSet(int expectedElements) {
        this.keys = new long[0];
        this.loadFactor = 0.75;
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ LongScatterSet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        this(n);
    }

    public LongScatterSet() {
        this(0, 1, null);
    }
}

