/*
 * Decompiled with CFR 0.152.
 */
package shark.internal.hppc;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.internal.hppc.HPPC;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0011\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0006\u0010\u001f\u001a\u00020\u0012J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0006\u0010#\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lshark/internal/hppc/LongScatterSet;", "", "expectedElements", "", "(I)V", "assigned", "hasEmptyKey", "", "keys", "", "loadFactor", "", "mask", "resizeAt", "add", "key", "", "allocateBuffers", "", "arraySize", "allocateThenInsertThenRehash", "slot", "pendingKey", "contains", "elementSequence", "Lkotlin/sequences/Sequence;", "ensureCapacity", "hashKey", "plusAssign", "rehash", "fromKeys", "release", "remove", "shiftConflictingKeys", "inputGapSlot", "size", "shark-graph"})
public final class LongScatterSet {
    @NotNull
    private long[] keys;
    private int assigned;
    private int mask;
    private int resizeAt;
    private boolean hasEmptyKey;
    private final double loadFactor;

    public LongScatterSet(int expectedElements) {
        this.keys = new long[0];
        this.loadFactor = 0.75;
        this.ensureCapacity(expectedElements);
    }

    public /* synthetic */ LongScatterSet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        this(n);
    }

    @NotNull
    public final Sequence<Long> elementSequence() {
        int max = this.mask + 1;
        Ref.IntRef slot = new Ref.IntRef();
        slot.element = -1;
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<Long>(slot, max, this){
            final /* synthetic */ Ref.IntRef $slot;
            final /* synthetic */ int $max;
            final /* synthetic */ LongScatterSet this$0;
            {
                this.$slot = $slot;
                this.$max = $max;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Long invoke() {
                if (this.$slot.element < this.$max) {
                    long existing = 0L;
                    int n = this.$slot.element;
                    this.$slot.element = n + 1;
                    while (this.$slot.element < this.$max) {
                        existing = LongScatterSet.access$getKeys$p(this.this$0)[this.$slot.element];
                        if (existing != 0L) {
                            return existing;
                        }
                        n = this.$slot.element;
                        this.$slot.element = n + 1;
                    }
                }
                if (this.$slot.element == this.$max && LongScatterSet.access$getHasEmptyKey$p(this.this$0)) {
                    int n = this.$slot.element;
                    this.$slot.element = n + 1;
                    return 0L;
                }
                return null;
            }
        }));
    }

    private final int hashKey(long key) {
        return HPPC.INSTANCE.mixPhi(key);
    }

    public final void plusAssign(long key) {
        this.add(key);
    }

    public final boolean add(long key) {
        if (key == 0L) {
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        int n = this.assigned;
        this.assigned = n + 1;
        return true;
    }

    public final boolean contains(long key) {
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        long existing = keys[slot];
        while (existing != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
            existing = keys[slot];
        }
        return false;
    }

    public final boolean remove(long key) {
        boolean bl;
        if (key == 0L) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            bl = hadEmptyKey;
        } else {
            long[] keys = this.keys;
            int mask = this.mask;
            int slot = this.hashKey(key) & mask;
            long existing = keys[slot];
            while (existing != 0L) {
                if (existing == key) {
                    this.shiftConflictingKeys(slot);
                    return true;
                }
                slot = slot + 1 & mask;
                existing = keys[slot];
            }
            bl = false;
        }
        return bl;
    }

    private final void shiftConflictingKeys(int inputGapSlot) {
        int slot;
        long existing;
        int gapSlot = inputGapSlot;
        long[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        int n = this.assigned;
        this.assigned = n + -1;
    }

    public final void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.allocateBuffers(HPPC.INSTANCE.minBufferSize(4, this.loadFactor));
    }

    public final void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt) {
            long[] prevKeys = this.keys;
            this.allocateBuffers(HPPC.INSTANCE.minBufferSize(expectedElements, this.loadFactor));
            if (this.size() != 0) {
                this.rehash(prevKeys);
            }
        }
    }

    public final int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    private final void rehash(long[] fromKeys) {
        long[] keys = this.keys;
        int mask = this.mask;
        long existing = 0L;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            existing = fromKeys[i];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    private final void allocateBuffers(int arraySize) {
        long[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            Locale locale = Locale.ROOT;
            String string = "Not enough memory to allocate buffers for rehashing: %d -> %d";
            Object[] objectArray = new Object[]{this.size(), arraySize};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
            throw new RuntimeException(string2, e);
        }
        this.resizeAt = HPPC.INSTANCE.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    private final void allocateThenInsertThenRehash(int slot, long pendingKey) {
        long[] prevKeys = this.keys;
        this.allocateBuffers(HPPC.INSTANCE.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    public LongScatterSet() {
        this(0, 1, null);
    }

    public static final /* synthetic */ long[] access$getKeys$p(LongScatterSet $this) {
        return $this.keys;
    }

    public static final /* synthetic */ boolean access$getHasEmptyKey$p(LongScatterSet $this) {
        return $this.hasEmptyKey;
    }
}

