/*
 * Decompiled with CFR 0.152.
 */
package shark;

import java.io.Closeable;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shark.CloseableHeapGraph;
import shark.DualSourceProvider;
import shark.FileSourceProvider;
import shark.GcRoot;
import shark.GraphContext;
import shark.HeapObject;
import shark.HprofHeader;
import shark.HprofHeapGraph;
import shark.HprofIndex;
import shark.HprofRecord;
import shark.HprofRecordReader;
import shark.HprofRecordTag;
import shark.HprofVersion;
import shark.PrimitiveType;
import shark.ProguardMapping;
import shark.RandomAccessHprofReader;
import shark.internal.FieldValuesReader;
import shark.internal.HprofInMemoryIndex;
import shark.internal.IndexedObject;
import shark.internal.LruCache;
import shark.internal.hppc.IntObjectPair;
import shark.internal.hppc.LongObjectPair;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 |2\u00020\u0001:\u0001|B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u00172\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020@2\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\bAJ\u001b\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00172\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\bDJ\u0015\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020,H\u0000\u00a2\u0006\u0002\bHJ\b\u0010I\u001a\u00020JH\u0016J\u0015\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ\u001d\u0010P\u001a\u00020F2\u0006\u0010G\u001a\u00020,2\u0006\u0010Q\u001a\u00020;H\u0000\u00a2\u0006\u0002\bRJ\u0012\u0010S\u001a\u0004\u0018\u00010\u000f2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010T\u001a\u00020\n2\u0006\u0010U\u001a\u00020,H\u0016J\u0010\u0010V\u001a\u0002012\u0006\u0010W\u001a\u00020\nH\u0016J\u0010\u0010X\u001a\u0002012\u0006\u0010U\u001a\u00020,H\u0016J\u0012\u0010Y\u001a\u0004\u0018\u0001012\u0006\u0010U\u001a\u00020,H\u0016J\u0010\u0010Z\u001a\u0002012\u0006\u0010[\u001a\u00020\nH\u0016J\u0006\u0010\\\u001a\u00020FJ\u0010\u0010]\u001a\u00020@2\u0006\u0010U\u001a\u00020,H\u0016J\u001d\u0010^\u001a\u00020_2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020=H\u0000\u00a2\u0006\u0002\baJ\u001d\u0010b\u001a\u00020N2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020cH\u0000\u00a2\u0006\u0002\bdJ\u001d\u0010e\u001a\u00020\n2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020fH\u0000\u00a2\u0006\u0002\bgJ\u001d\u0010h\u001a\u00020i2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020fH\u0000\u00a2\u0006\u0002\bjJ@\u0010k\u001a\u0002Hl\"\b\b\u0000\u0010l*\u00020-2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020m2\u0017\u0010n\u001a\u0013\u0012\u0004\u0012\u00020p\u0012\u0004\u0012\u0002Hl0o\u00a2\u0006\u0002\bqH\u0002\u00a2\u0006\u0002\u0010rJ\u001d\u0010s\u001a\u00020\n2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020tH\u0000\u00a2\u0006\u0002\buJ\u001d\u0010v\u001a\u00020w2\u0006\u0010U\u001a\u00020,2\u0006\u0010`\u001a\u00020tH\u0000\u00a2\u0006\u0002\bxJ\u001d\u0010y\u001a\u00020F2\u0006\u0010G\u001a\u00020,2\u0006\u0010Q\u001a\u00020CH\u0000\u00a2\u0006\u0002\bzJ \u0010{\u001a\u0002012\u0006\u0010[\u001a\u00020\n2\u0006\u0010`\u001a\u00020m2\u0006\u0010U\u001a\u00020,H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\fR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0011R\u0010\u0010\"\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\fR\u0014\u0010%\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\fR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0011R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\fR\u001a\u00100\u001a\b\u0012\u0004\u0012\u0002010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0011R\u0014\u00103\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\fR\u0014\u00105\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\fR\u001a\u00107\u001a\b\u0012\u0004\u0012\u0002080\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lshark/HprofHeapGraph;", "Lshark/CloseableHeapGraph;", "header", "Lshark/HprofHeader;", "reader", "Lshark/RandomAccessHprofReader;", "index", "Lshark/internal/HprofInMemoryIndex;", "(Lshark/HprofHeader;Lshark/RandomAccessHprofReader;Lshark/internal/HprofInMemoryIndex;)V", "classCount", "", "getClassCount", "()I", "classes", "Lkotlin/sequences/Sequence;", "Lshark/HeapObject$HeapClass;", "getClasses", "()Lkotlin/sequences/Sequence;", "context", "Lshark/GraphContext;", "getContext", "()Lshark/GraphContext;", "gcRoots", "", "Lshark/GcRoot;", "getGcRoots", "()Ljava/util/List;", "identifierByteSize", "getIdentifierByteSize", "instanceCount", "getInstanceCount", "instances", "Lshark/HeapObject$HeapInstance;", "getInstances", "javaLangObjectClass", "objectArrayCount", "getObjectArrayCount", "objectArrayRecordNonElementSize", "getObjectArrayRecordNonElementSize$shark_graph", "objectArrays", "Lshark/HeapObject$HeapObjectArray;", "getObjectArrays", "objectCache", "Lshark/internal/LruCache;", "", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord;", "objectCount", "getObjectCount", "objects", "Lshark/HeapObject;", "getObjects", "primitiveArrayCount", "getPrimitiveArrayCount", "primitiveArrayRecordNonElementSize", "getPrimitiveArrayRecordNonElementSize$shark_graph", "primitiveArrays", "Lshark/HeapObject$HeapPrimitiveArray;", "getPrimitiveArrays", "classDumpFields", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$FieldRecord;", "indexedClass", "Lshark/internal/IndexedObject$IndexedClass;", "classDumpFields$shark_graph", "classDumpHasReferenceFields", "", "classDumpHasReferenceFields$shark_graph", "classDumpStaticFields", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord$StaticFieldRecord;", "classDumpStaticFields$shark_graph", "className", "", "classId", "className$shark_graph", "close", "", "createFieldValuesReader", "Lshark/internal/FieldValuesReader;", "record", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$InstanceDumpRecord;", "createFieldValuesReader$shark_graph", "fieldName", "fieldRecord", "fieldName$shark_graph", "findClassByName", "findHeapDumpIndex", "objectId", "findObjectByHeapDumpIndex", "heapDumpIndex", "findObjectById", "findObjectByIdOrNull", "findObjectByIndex", "objectIndex", "lruCacheStats", "objectExists", "readClassDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ClassDumpRecord;", "indexedObject", "readClassDumpRecord$shark_graph", "readInstanceDumpRecord", "Lshark/internal/IndexedObject$IndexedInstance;", "readInstanceDumpRecord$shark_graph", "readObjectArrayByteSize", "Lshark/internal/IndexedObject$IndexedObjectArray;", "readObjectArrayByteSize$shark_graph", "readObjectArrayDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$ObjectArrayDumpRecord;", "readObjectArrayDumpRecord$shark_graph", "readObjectRecord", "T", "Lshark/internal/IndexedObject;", "readBlock", "Lkotlin/Function1;", "Lshark/HprofRecordReader;", "Lkotlin/ExtensionFunctionType;", "(JLshark/internal/IndexedObject;Lkotlin/jvm/functions/Function1;)Lshark/HprofRecord$HeapDumpRecord$ObjectRecord;", "readPrimitiveArrayByteSize", "Lshark/internal/IndexedObject$IndexedPrimitiveArray;", "readPrimitiveArrayByteSize$shark_graph", "readPrimitiveArrayDumpRecord", "Lshark/HprofRecord$HeapDumpRecord$ObjectRecord$PrimitiveArrayDumpRecord;", "readPrimitiveArrayDumpRecord$shark_graph", "staticFieldName", "staticFieldName$shark_graph", "wrapIndexedObject", "Companion", "shark-graph"})
@SourceDebugExtension(value={"SMAP\nHprofHeapGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HprofHeapGraph.kt\nshark/HprofHeapGraph\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1295#2,2:429\n1045#3:431\n1#4:432\n*S KotlinDebug\n*F\n+ 1 HprofHeapGraph.kt\nshark/HprofHeapGraph\n*L\n196#1:429,2\n208#1:431\n*E\n"})
public final class HprofHeapGraph
implements CloseableHeapGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HprofHeader header;
    @NotNull
    private final RandomAccessHprofReader reader;
    @NotNull
    private final HprofInMemoryIndex index;
    @NotNull
    private final GraphContext context;
    @NotNull
    private final LruCache<Long, HprofRecord.HeapDumpRecord.ObjectRecord> objectCache;
    @Nullable
    private final HeapObject.HeapClass javaLangObjectClass;
    private final int objectArrayRecordNonElementSize;
    private final int primitiveArrayRecordNonElementSize;
    private static int INTERNAL_LRU_CACHE_SIZE = 3000;

    public HprofHeapGraph(@NotNull HprofHeader header, @NotNull RandomAccessHprofReader reader, @NotNull HprofInMemoryIndex index) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        this.header = header;
        this.reader = reader;
        this.index = index;
        this.context = new GraphContext();
        this.objectCache = new LruCache(INTERNAL_LRU_CACHE_SIZE);
        this.javaLangObjectClass = this.findClassByName("java.lang.Object");
        this.objectArrayRecordNonElementSize = 2 * this.getIdentifierByteSize() + 2 * PrimitiveType.INT.getByteSize();
        this.primitiveArrayRecordNonElementSize = this.getIdentifierByteSize() + 2 * PrimitiveType.INT.getByteSize() + PrimitiveType.BYTE.getByteSize();
    }

    @Override
    public int getIdentifierByteSize() {
        return this.header.getIdentifierByteSize();
    }

    @Override
    @NotNull
    public GraphContext getContext() {
        return this.context;
    }

    @Override
    public int getObjectCount() {
        return this.getClassCount() + this.getInstanceCount() + this.getObjectArrayCount() + this.getPrimitiveArrayCount();
    }

    @Override
    public int getClassCount() {
        return this.index.getClassCount();
    }

    @Override
    public int getInstanceCount() {
        return this.index.getInstanceCount();
    }

    @Override
    public int getObjectArrayCount() {
        return this.index.getObjectArrayCount();
    }

    @Override
    public int getPrimitiveArrayCount() {
        return this.index.getPrimitiveArrayCount();
    }

    @Override
    @NotNull
    public List<GcRoot> getGcRoots() {
        return this.index.gcRoots();
    }

    @Override
    @NotNull
    public Sequence<HeapObject> getObjects() {
        Ref.IntRef objectIndex = new Ref.IntRef();
        return SequencesKt.map(this.index.indexedObjectSequence(), (Function1)((Function1)new Function1<LongObjectPair<? extends IndexedObject>, HeapObject>(this, objectIndex){
            final /* synthetic */ HprofHeapGraph this$0;
            final /* synthetic */ Ref.IntRef $objectIndex;
            {
                this.this$0 = $receiver;
                this.$objectIndex = $objectIndex;
                super(1);
            }

            @NotNull
            public final HeapObject invoke(@NotNull LongObjectPair<? extends IndexedObject> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                int n = this.$objectIndex.element;
                this.$objectIndex.element = n + 1;
                return HprofHeapGraph.access$wrapIndexedObject(this.this$0, n, it.getSecond(), it.getFirst());
            }
        }));
    }

    @Override
    @NotNull
    public Sequence<HeapObject.HeapClass> getClasses() {
        Ref.IntRef objectIndex = new Ref.IntRef();
        return SequencesKt.map(this.index.indexedClassSequence(), (Function1)((Function1)new Function1<LongObjectPair<? extends IndexedObject.IndexedClass>, HeapObject.HeapClass>(this, objectIndex){
            final /* synthetic */ HprofHeapGraph this$0;
            final /* synthetic */ Ref.IntRef $objectIndex;
            {
                this.this$0 = $receiver;
                this.$objectIndex = $objectIndex;
                super(1);
            }

            @NotNull
            public final HeapObject.HeapClass invoke(@NotNull LongObjectPair<IndexedObject.IndexedClass> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                long objectId = it.getFirst();
                IndexedObject.IndexedClass indexedObject = it.getSecond();
                int n = this.$objectIndex.element;
                this.$objectIndex.element = n + 1;
                return new HeapObject.HeapClass(this.this$0, indexedObject, objectId, n);
            }
        }));
    }

    @Override
    @NotNull
    public Sequence<HeapObject.HeapInstance> getInstances() {
        Ref.IntRef objectIndex = new Ref.IntRef();
        objectIndex.element = this.getClassCount();
        return SequencesKt.map(this.index.indexedInstanceSequence(), (Function1)((Function1)new Function1<LongObjectPair<? extends IndexedObject.IndexedInstance>, HeapObject.HeapInstance>(this, objectIndex){
            final /* synthetic */ HprofHeapGraph this$0;
            final /* synthetic */ Ref.IntRef $objectIndex;
            {
                this.this$0 = $receiver;
                this.$objectIndex = $objectIndex;
                super(1);
            }

            @NotNull
            public final HeapObject.HeapInstance invoke(@NotNull LongObjectPair<IndexedObject.IndexedInstance> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                long objectId = it.getFirst();
                IndexedObject.IndexedInstance indexedObject = it.getSecond();
                int n = this.$objectIndex.element;
                this.$objectIndex.element = n + 1;
                return new HeapObject.HeapInstance(this.this$0, indexedObject, objectId, n);
            }
        }));
    }

    @Override
    @NotNull
    public Sequence<HeapObject.HeapObjectArray> getObjectArrays() {
        Ref.IntRef objectIndex = new Ref.IntRef();
        objectIndex.element = this.getClassCount() + this.getInstanceCount();
        return SequencesKt.map(this.index.indexedObjectArraySequence(), (Function1)((Function1)new Function1<LongObjectPair<? extends IndexedObject.IndexedObjectArray>, HeapObject.HeapObjectArray>(this, objectIndex){
            final /* synthetic */ HprofHeapGraph this$0;
            final /* synthetic */ Ref.IntRef $objectIndex;
            {
                this.this$0 = $receiver;
                this.$objectIndex = $objectIndex;
                super(1);
            }

            @NotNull
            public final HeapObject.HeapObjectArray invoke(@NotNull LongObjectPair<IndexedObject.IndexedObjectArray> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                long objectId = it.getFirst();
                IndexedObject.IndexedObjectArray indexedObject = it.getSecond();
                int n = this.$objectIndex.element;
                this.$objectIndex.element = n + 1;
                return new HeapObject.HeapObjectArray(this.this$0, indexedObject, objectId, n);
            }
        }));
    }

    @Override
    @NotNull
    public Sequence<HeapObject.HeapPrimitiveArray> getPrimitiveArrays() {
        Ref.IntRef objectIndex = new Ref.IntRef();
        objectIndex.element = this.getClassCount() + this.getInstanceCount() + this.getObjectArrayCount();
        return SequencesKt.map(this.index.indexedPrimitiveArraySequence(), (Function1)((Function1)new Function1<LongObjectPair<? extends IndexedObject.IndexedPrimitiveArray>, HeapObject.HeapPrimitiveArray>(this, objectIndex){
            final /* synthetic */ HprofHeapGraph this$0;
            final /* synthetic */ Ref.IntRef $objectIndex;
            {
                this.this$0 = $receiver;
                this.$objectIndex = $objectIndex;
                super(1);
            }

            @NotNull
            public final HeapObject.HeapPrimitiveArray invoke(@NotNull LongObjectPair<IndexedObject.IndexedPrimitiveArray> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                long objectId = it.getFirst();
                IndexedObject.IndexedPrimitiveArray indexedObject = it.getSecond();
                int n = this.$objectIndex.element;
                this.$objectIndex.element = n + 1;
                return new HeapObject.HeapPrimitiveArray(this.this$0, indexedObject, objectId, n);
            }
        }));
    }

    public final int getObjectArrayRecordNonElementSize$shark_graph() {
        return this.objectArrayRecordNonElementSize;
    }

    public final int getPrimitiveArrayRecordNonElementSize$shark_graph() {
        return this.primitiveArrayRecordNonElementSize;
    }

    @NotNull
    public final String lruCacheStats() {
        return this.objectCache.toString();
    }

    @Override
    @NotNull
    public HeapObject findObjectById(long objectId) {
        HeapObject heapObject = this.findObjectByIdOrNull(objectId);
        if (heapObject == null) {
            throw new IllegalArgumentException("Object id " + objectId + " not found in heap dump.");
        }
        return heapObject;
    }

    @Override
    @NotNull
    public HeapObject findObjectByIndex(int objectIndex) {
        if (!(0 <= objectIndex ? objectIndex < this.getObjectCount() : false)) {
            boolean $i$a$-require-HprofHeapGraph$findObjectByIndex$22 = false;
            String $i$a$-require-HprofHeapGraph$findObjectByIndex$22 = objectIndex + " should be in range [0, " + this.getObjectCount() + '[';
            throw new IllegalArgumentException($i$a$-require-HprofHeapGraph$findObjectByIndex$22.toString());
        }
        LongObjectPair<IndexedObject> longObjectPair = this.index.objectAtIndex(objectIndex);
        long objectId = longObjectPair.component1();
        IndexedObject indexedObject = longObjectPair.component2();
        return this.wrapIndexedObject(objectIndex, indexedObject, objectId);
    }

    @Override
    @Nullable
    public HeapObject findObjectByIdOrNull(long objectId) {
        Object object = this.javaLangObjectClass;
        boolean bl = object != null ? objectId == ((HeapObject.HeapClass)object).getObjectId() : false;
        if (bl) {
            return this.javaLangObjectClass;
        }
        IntObjectPair<IndexedObject> intObjectPair = this.index.indexedObjectOrNull(objectId);
        if (intObjectPair == null) {
            return null;
        }
        object = intObjectPair;
        int objectIndex = ((IntObjectPair)object).component1();
        IndexedObject indexedObject = (IndexedObject)((IntObjectPair)object).component2();
        return this.wrapIndexedObject(objectIndex, indexedObject, objectId);
    }

    @Override
    @Nullable
    public HeapObject.HeapClass findClassByName(@NotNull String className) {
        String string;
        block29: {
            block26: {
                block27: {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                    if (this.header.getVersion() == HprofVersion.ANDROID) break block26;
                    int indexOfArrayChar = StringsKt.indexOf$default((CharSequence)className, (char)'[', (int)0, (boolean)false, (int)6, null);
                    if (indexOfArrayChar == -1) break block27;
                    int dimensions = (className.length() - indexOfArrayChar) / 2;
                    String string2 = className.substring(0, indexOfArrayChar);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String componentClassName = string2;
                    StringBuilder stringBuilder = new StringBuilder().append(StringsKt.repeat((CharSequence)"[", (int)dimensions));
                    switch (componentClassName) {
                        case "char": {
                            object = Character.valueOf('C');
                            break;
                        }
                        case "float": {
                            object = Character.valueOf('F');
                            break;
                        }
                        case "double": {
                            object = Character.valueOf('D');
                            break;
                        }
                        case "byte": {
                            object = Character.valueOf('B');
                            break;
                        }
                        case "short": {
                            object = Character.valueOf('S');
                            break;
                        }
                        case "int": {
                            object = Character.valueOf('I');
                            break;
                        }
                        case "long": {
                            object = Character.valueOf('J');
                            break;
                        }
                        default: {
                            object = 'L' + componentClassName + ';';
                        }
                    }
                    string = stringBuilder.append(object).toString();
                    break block29;
                }
                string = className;
                break block29;
            }
            string = className;
        }
        String heapDumpClassName = string;
        Long classId = this.index.classId(heapDumpClassName);
        if (classId != null) {
            HeapObject heapObject = this.findObjectById(classId);
            Intrinsics.checkNotNull((Object)heapObject, (String)"null cannot be cast to non-null type shark.HeapObject.HeapClass");
            return (HeapObject.HeapClass)heapObject;
        }
        return null;
    }

    @Override
    public boolean objectExists(long objectId) {
        return this.index.objectIdIsIndexed(objectId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int findHeapDumpIndex(long objectId) {
        void $this$forEach$iv;
        IntObjectPair<IndexedObject> intObjectPair = this.index.indexedObjectOrNull(objectId);
        if (intObjectPair == null) {
            throw new IllegalArgumentException("Object id " + objectId + " not found in heap dump.");
        }
        IndexedObject indexedObject = intObjectPair.component2();
        long position = indexedObject.getPosition();
        int countObjectsBefore = 0;
        countObjectsBefore = 1;
        Sequence<LongObjectPair<IndexedObject>> sequence = this.index.indexedObjectSequence();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LongObjectPair it = (LongObjectPair)element$iv;
            boolean bl = false;
            if (position <= ((IndexedObject)it.getSecond()).getPosition()) continue;
            ++countObjectsBefore;
        }
        return countObjectsBefore;
    }

    @Override
    @NotNull
    public HeapObject findObjectByHeapDumpIndex(int heapDumpIndex) {
        if (!(1 <= heapDumpIndex ? heapDumpIndex <= this.getObjectCount() : false)) {
            boolean $i$a$-require-HprofHeapGraph$findObjectByHeapDumpIndex$22 = false;
            String $i$a$-require-HprofHeapGraph$findObjectByHeapDumpIndex$22 = heapDumpIndex + " should be in range [1, " + this.getObjectCount() + ']';
            throw new IllegalArgumentException($i$a$-require-HprofHeapGraph$findObjectByHeapDumpIndex$22.toString());
        }
        Iterable $this$sortedBy$iv = SequencesKt.toList(this.index.indexedObjectSequence());
        boolean $i$f$sortedBy = false;
        long objectId = ((LongObjectPair)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LongObjectPair it = (LongObjectPair)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(((IndexedObject)it.getSecond()).getPosition());
                it = (LongObjectPair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((IndexedObject)it.getSecond()).getPosition()));
            }
        }).get(heapDumpIndex)).component1();
        return this.findObjectById(objectId);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @NotNull
    public final List<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord> classDumpStaticFields$shark_graph(@NotNull IndexedObject.IndexedClass indexedClass) {
        Intrinsics.checkNotNullParameter((Object)indexedClass, (String)"indexedClass");
        return this.index.getClassFieldsReader().classDumpStaticFields(indexedClass);
    }

    @NotNull
    public final List<HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord> classDumpFields$shark_graph(@NotNull IndexedObject.IndexedClass indexedClass) {
        Intrinsics.checkNotNullParameter((Object)indexedClass, (String)"indexedClass");
        return this.index.getClassFieldsReader().classDumpFields(indexedClass);
    }

    public final boolean classDumpHasReferenceFields$shark_graph(@NotNull IndexedObject.IndexedClass indexedClass) {
        Intrinsics.checkNotNullParameter((Object)indexedClass, (String)"indexedClass");
        return this.index.getClassFieldsReader().classDumpHasReferenceFields(indexedClass);
    }

    @NotNull
    public final String fieldName$shark_graph(long classId, @NotNull HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.FieldRecord fieldRecord) {
        Intrinsics.checkNotNullParameter((Object)fieldRecord, (String)"fieldRecord");
        return this.index.fieldName(classId, fieldRecord.getNameStringId());
    }

    @NotNull
    public final String staticFieldName$shark_graph(long classId, @NotNull HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord.StaticFieldRecord fieldRecord) {
        Intrinsics.checkNotNullParameter((Object)fieldRecord, (String)"fieldRecord");
        return this.index.fieldName(classId, fieldRecord.getNameStringId());
    }

    @NotNull
    public final FieldValuesReader createFieldValuesReader$shark_graph(@NotNull HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        return new FieldValuesReader(record, this.getIdentifierByteSize());
    }

    @NotNull
    public final String className$shark_graph(long classId) {
        String hprofClassName = this.index.className(classId);
        if (this.header.getVersion() != HprofVersion.ANDROID && StringsKt.startsWith$default((CharSequence)hprofClassName, (char)'[', (boolean)false, (int)2, null)) {
            String string;
            int arrayCharLastIndex = StringsKt.lastIndexOf$default((CharSequence)hprofClassName, (char)'[', (int)0, (boolean)false, (int)6, null);
            String brackets = StringsKt.repeat((CharSequence)"[]", (int)(arrayCharLastIndex + 1));
            char typeChar = hprofClassName.charAt(arrayCharLastIndex + 1);
            if (typeChar == 'L') {
                int classNameStart = arrayCharLastIndex + 2;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = hprofClassName.substring(classNameStart, hprofClassName.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = stringBuilder.append(string2).append(brackets).toString();
            } else if (typeChar == 'Z') {
                string = "boolean" + brackets;
            } else if (typeChar == 'C') {
                string = "char" + brackets;
            } else if (typeChar == 'F') {
                string = "float" + brackets;
            } else if (typeChar == 'D') {
                string = "double" + brackets;
            } else if (typeChar == 'B') {
                string = "byte" + brackets;
            } else if (typeChar == 'S') {
                string = "short" + brackets;
            } else if (typeChar == 'I') {
                string = "int" + brackets;
            } else if (typeChar == 'J') {
                string = "long" + brackets;
            } else {
                throw new IllegalStateException(("Unexpected type char " + typeChar).toString());
            }
            return string;
        }
        return hprofClassName;
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord readObjectArrayDumpRecord$shark_graph(long objectId, @NotNull IndexedObject.IndexedObjectArray indexedObject) {
        Intrinsics.checkNotNullParameter((Object)indexedObject, (String)"indexedObject");
        return (HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)this.readObjectRecord(objectId, indexedObject, readObjectArrayDumpRecord.1.INSTANCE);
    }

    public final int readObjectArrayByteSize$shark_graph(long objectId, @NotNull IndexedObject.IndexedObjectArray indexedObject) {
        Intrinsics.checkNotNullParameter((Object)indexedObject, (String)"indexedObject");
        HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord cachedRecord = (HprofRecord.HeapDumpRecord.ObjectRecord.ObjectArrayDumpRecord)this.objectCache.get(objectId);
        if (cachedRecord != null) {
            return cachedRecord.getElementIds().length * this.getIdentifierByteSize();
        }
        long position = indexedObject.getPosition() + (long)this.getIdentifierByteSize() + (long)PrimitiveType.INT.getByteSize();
        long size2 = PrimitiveType.INT.getByteSize();
        int thinRecordSize2 = ((Number)this.reader.readRecord(position, size2, (Function1)readObjectArrayByteSize.thinRecordSize.1.INSTANCE)).intValue();
        return thinRecordSize2 * this.getIdentifierByteSize();
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord readPrimitiveArrayDumpRecord$shark_graph(long objectId, @NotNull IndexedObject.IndexedPrimitiveArray indexedObject) {
        Intrinsics.checkNotNullParameter((Object)indexedObject, (String)"indexedObject");
        return (HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord)this.readObjectRecord(objectId, indexedObject, readPrimitiveArrayDumpRecord.1.INSTANCE);
    }

    public final int readPrimitiveArrayByteSize$shark_graph(long objectId, @NotNull IndexedObject.IndexedPrimitiveArray indexedObject) {
        Intrinsics.checkNotNullParameter((Object)indexedObject, (String)"indexedObject");
        HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord cachedRecord = (HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord)this.objectCache.get(objectId);
        if (cachedRecord != null) {
            int n;
            HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord primitiveArrayDumpRecord = cachedRecord;
            if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.BooleanArrayDump)cachedRecord).getArray().length * PrimitiveType.BOOLEAN.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.CharArrayDump)cachedRecord).getArray().length * PrimitiveType.CHAR.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.FloatArrayDump)cachedRecord).getArray().length * PrimitiveType.FLOAT.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.DoubleArrayDump)cachedRecord).getArray().length * PrimitiveType.DOUBLE.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ByteArrayDump)cachedRecord).getArray().length * PrimitiveType.BYTE.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.ShortArrayDump)cachedRecord).getArray().length * PrimitiveType.SHORT.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.IntArrayDump)cachedRecord).getArray().length * PrimitiveType.INT.getByteSize();
            } else if (primitiveArrayDumpRecord instanceof HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump) {
                n = ((HprofRecord.HeapDumpRecord.ObjectRecord.PrimitiveArrayDumpRecord.LongArrayDump)cachedRecord).getArray().length * PrimitiveType.LONG.getByteSize();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }
        long position = indexedObject.getPosition() + (long)this.getIdentifierByteSize() + (long)PrimitiveType.INT.getByteSize();
        int size2 = ((Number)this.reader.readRecord(position, (long)PrimitiveType.INT.getByteSize(), (Function1)readPrimitiveArrayByteSize.size.1.INSTANCE)).intValue();
        return size2 * indexedObject.getPrimitiveType().getByteSize();
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord readClassDumpRecord$shark_graph(long objectId, @NotNull IndexedObject.IndexedClass indexedObject) {
        Intrinsics.checkNotNullParameter((Object)indexedObject, (String)"indexedObject");
        return (HprofRecord.HeapDumpRecord.ObjectRecord.ClassDumpRecord)this.readObjectRecord(objectId, indexedObject, readClassDumpRecord.1.INSTANCE);
    }

    @NotNull
    public final HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord readInstanceDumpRecord$shark_graph(long objectId, @NotNull IndexedObject.IndexedInstance indexedObject) {
        Intrinsics.checkNotNullParameter((Object)indexedObject, (String)"indexedObject");
        return (HprofRecord.HeapDumpRecord.ObjectRecord.InstanceDumpRecord)this.readObjectRecord(objectId, indexedObject, readInstanceDumpRecord.1.INSTANCE);
    }

    private final <T extends HprofRecord.HeapDumpRecord.ObjectRecord> T readObjectRecord(long objectId, IndexedObject indexedObject, Function1<? super HprofRecordReader, ? extends T> readBlock) {
        HprofRecord.HeapDumpRecord.ObjectRecord objectRecordOrNull = this.objectCache.get(objectId);
        if (objectRecordOrNull != null) {
            return (T)objectRecordOrNull;
        }
        Object object = this.reader.readRecord(indexedObject.getPosition(), indexedObject.getRecordSize(), new Function1<HprofRecordReader, T>(readBlock){
            final /* synthetic */ Function1<HprofRecordReader, T> $readBlock;
            {
                this.$readBlock = $readBlock;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull HprofRecordReader $this$readRecord) {
                Intrinsics.checkNotNullParameter((Object)$this$readRecord, (String)"$this$readRecord");
                return (T)((HprofRecord.HeapDumpRecord.ObjectRecord)this.$readBlock.invoke((Object)$this$readRecord));
            }
        });
        HprofRecord.HeapDumpRecord.ObjectRecord $this$readObjectRecord_u24lambda_u244 = (HprofRecord.HeapDumpRecord.ObjectRecord)object;
        boolean bl = false;
        this.objectCache.put(objectId, $this$readObjectRecord_u24lambda_u244);
        return (T)((HprofRecord.HeapDumpRecord.ObjectRecord)object);
    }

    private final HeapObject wrapIndexedObject(int objectIndex, IndexedObject indexedObject, long objectId) {
        HeapObject heapObject;
        IndexedObject indexedObject2 = indexedObject;
        if (indexedObject2 instanceof IndexedObject.IndexedClass) {
            heapObject = new HeapObject.HeapClass(this, (IndexedObject.IndexedClass)indexedObject, objectId, objectIndex);
        } else if (indexedObject2 instanceof IndexedObject.IndexedInstance) {
            heapObject = new HeapObject.HeapInstance(this, (IndexedObject.IndexedInstance)indexedObject, objectId, objectIndex);
        } else if (indexedObject2 instanceof IndexedObject.IndexedObjectArray) {
            heapObject = new HeapObject.HeapObjectArray(this, (IndexedObject.IndexedObjectArray)indexedObject, objectId, objectIndex);
        } else if (indexedObject2 instanceof IndexedObject.IndexedPrimitiveArray) {
            heapObject = new HeapObject.HeapPrimitiveArray(this, (IndexedObject.IndexedPrimitiveArray)indexedObject, objectId, objectIndex);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return heapObject;
    }

    public static final /* synthetic */ HeapObject access$wrapIndexedObject(HprofHeapGraph $this, int objectIndex, IndexedObject indexedObject, long objectId) {
        return $this.wrapIndexedObject(objectIndex, indexedObject, objectId);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n*\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ&\u0010\t\u001a\u00020\n*\u00020\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lshark/HprofHeapGraph$Companion;", "", "()V", "INTERNAL_LRU_CACHE_SIZE", "", "getINTERNAL_LRU_CACHE_SIZE", "()I", "setINTERNAL_LRU_CACHE_SIZE", "(I)V", "openHeapGraph", "Lshark/CloseableHeapGraph;", "Ljava/io/File;", "proguardMapping", "Lshark/ProguardMapping;", "indexedGcRootTypes", "", "Lshark/HprofRecordTag;", "Lshark/DualSourceProvider;", "shark-graph"})
    @SourceDebugExtension(value={"SMAP\nHprofHeapGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HprofHeapGraph.kt\nshark/HprofHeapGraph$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getINTERNAL_LRU_CACHE_SIZE() {
            return INTERNAL_LRU_CACHE_SIZE;
        }

        public final void setINTERNAL_LRU_CACHE_SIZE(int n) {
            INTERNAL_LRU_CACHE_SIZE = n;
        }

        @NotNull
        public final CloseableHeapGraph openHeapGraph(@NotNull File $this$openHeapGraph, @Nullable ProguardMapping proguardMapping, @NotNull Set<? extends HprofRecordTag> indexedGcRootTypes) {
            Intrinsics.checkNotNullParameter((Object)$this$openHeapGraph, (String)"<this>");
            Intrinsics.checkNotNullParameter(indexedGcRootTypes, (String)"indexedGcRootTypes");
            return this.openHeapGraph((DualSourceProvider)new FileSourceProvider($this$openHeapGraph), proguardMapping, indexedGcRootTypes);
        }

        public static /* synthetic */ CloseableHeapGraph openHeapGraph$default(Companion companion, File file, ProguardMapping proguardMapping, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                proguardMapping = null;
            }
            if ((n & 2) != 0) {
                set = HprofIndex.Companion.defaultIndexedGcRootTags();
            }
            return companion.openHeapGraph(file, proguardMapping, (Set<? extends HprofRecordTag>)set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CloseableHeapGraph openHeapGraph(@NotNull DualSourceProvider $this$openHeapGraph, @Nullable ProguardMapping proguardMapping, @NotNull Set<? extends HprofRecordTag> indexedGcRootTypes) {
            HprofHeader hprofHeader;
            Intrinsics.checkNotNullParameter((Object)$this$openHeapGraph, (String)"<this>");
            Intrinsics.checkNotNullParameter(indexedGcRootTypes, (String)"indexedGcRootTypes");
            Closeable closeable = (Closeable)$this$openHeapGraph.openStreamingSource();
            Throwable throwable = null;
            try {
                BufferedSource it = (BufferedSource)closeable;
                boolean bl = false;
                hprofHeader = HprofHeader.Companion.parseHeaderOf(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            HprofHeader header = hprofHeader;
            HprofIndex index = HprofIndex.Companion.indexRecordsOf($this$openHeapGraph, header, proguardMapping, indexedGcRootTypes);
            return index.openHeapGraph();
        }

        public static /* synthetic */ CloseableHeapGraph openHeapGraph$default(Companion companion, DualSourceProvider dualSourceProvider, ProguardMapping proguardMapping, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                proguardMapping = null;
            }
            if ((n & 2) != 0) {
                set = HprofIndex.Companion.defaultIndexedGcRootTags();
            }
            return companion.openHeapGraph(dualSourceProvider, proguardMapping, (Set<? extends HprofRecordTag>)set);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

