/*
 * Decompiled with CFR 0.152.
 */
package cash.detektive.javacompat;

import cash.detektive.javacompat.AnnotatePublicApisWithJvmOverloads;
import cash.detektive.javacompat.AnnotatePublicApisWithJvmOverloadsKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.CorrectableCodeSmell;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.api.internal.SuppressionsKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J%\u0010\u0019\u001a\u00020\u0010*\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcash/detektive/javacompat/AnnotatePublicApisWithJvmOverloads;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtFunction;", "elementType", "Lcash/detektive/javacompat/AnnotatePublicApisWithJvmOverloads$ElementType;", "isApplicable", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "hasAnyAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "annotationFqNames", "", "", "(Lorg/jetbrains/kotlin/psi/KtAnnotated;[Ljava/lang/String;)Z", "ElementType", "detektive"})
@SourceDebugExtension(value={"SMAP\nAnnotatePublicApisWithJvmOverloads.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotatePublicApisWithJvmOverloads.kt\ncash/detektive/javacompat/AnnotatePublicApisWithJvmOverloads\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,118:1\n1747#2,3:119\n1747#2,3:122\n1247#3,2:125\n*S KotlinDebug\n*F\n+ 1 AnnotatePublicApisWithJvmOverloads.kt\ncash/detektive/javacompat/AnnotatePublicApisWithJvmOverloads\n*L\n58#1:119,3\n90#1:122,3\n107#1:125,2\n*E\n"})
public final class AnnotatePublicApisWithJvmOverloads
extends Rule {
    @NotNull
    private final Issue issue;

    public AnnotatePublicApisWithJvmOverloads(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Public functions and constructors with default arguments should be annotated with @JvmOverloads", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.checkElement((KtFunction)function, ElementType.FUNCTION);
        super.visitNamedFunction(function);
    }

    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.checkElement((KtFunction)constructor, ElementType.CONSTRUCTOR);
        super.visitPrimaryConstructor(constructor);
    }

    private final void checkElement(KtFunction element, ElementType elementType) {
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (this.isApplicable(element, (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element))) {
            boolean bl;
            block12: {
                List list = element.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!AnnotatePublicApisWithJvmOverloadsKt.access$isOfType(it, Reflection.getOrCreateKotlinClass(JvmOverloads.class))) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                String string = elementType.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String message = "Public " + string + " '" + element.getNameAsSafeName() + "' with default arguments, but without @JvmOverloads annotation";
                if (this.getAutoCorrect()) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                    if (!SuppressionsKt.isSuppressedBy((KtElement)((KtElement)element), (String)this.getRuleId(), (Set)this.getAliases(), (String)this.getRuleSetConfig().getParentPath())) {
                        PsiElement psiElement = element.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
                        KtAnnotationEntry ktAnnotationEntry = element.addAnnotationEntry(KtPsiFactory.Companion.contextual(psiElement, true).createAnnotationEntry("@JvmOverloads"));
                        Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry, (String)"addAnnotationEntry(...)");
                        KtAnnotationEntry annotation = ktAnnotationEntry;
                        if (elementType == ElementType.CONSTRUCTOR) {
                            PsiElement psiElement2 = element.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                            annotation.addBefore(KtPsiFactory.Companion.contextual(psiElement2, true).createWhiteSpace(), null);
                            PsiElement psiElement3 = element.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"getParent(...)");
                            element.addAfter(KtPsiFactory.Companion.contextual(psiElement3, true).createWhiteSpace(), null);
                        } else if (elementType == ElementType.FUNCTION) {
                            PsiElement psiElement4 = element.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getParent(...)");
                            annotation.addBefore(KtPsiFactory.Companion.contextual(psiElement4, true).createNewLine(), null);
                        }
                    }
                    this.report((Finding)new CorrectableCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)element), message, null, null, true, 24, null));
                } else {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)element), message, null, null, 24, null));
                }
            }
        }
    }

    private final boolean isApplicable(KtFunction element, DeclarationDescriptor descriptor) {
        boolean bl;
        String[] $this$any$iv;
        block6: {
            KtClassOrObject containingType = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element));
            if (!(containingType instanceof KtClass) || ((KtClass)containingType).isInterface() || ((KtClass)containingType).isAnnotation()) {
                return false;
            }
            List list = element.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            $this$any$iv = (String[])list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object t : $this$any$iv) {
                    KtParameter it = (KtParameter)t;
                    boolean bl2 = false;
                    if (!it.hasDefaultValue()) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (!bl) {
            return false;
        }
        $this$any$iv = new String[]{"javax.inject.Inject", "jakarta.inject.Inject", "com.google.inject.Inject"};
        if (this.hasAnyAnnotation((KtAnnotated)element, $this$any$iv)) {
            return false;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)descriptor : null;
        CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor;
        Visibility visibility = callableMemberDescriptor2 != null && (callableMemberDescriptor2 = EffectiveVisibilityUtilsKt.effectiveVisibility$default((DeclarationDescriptorWithVisibility)((DeclarationDescriptorWithVisibility)callableMemberDescriptor2), null, (boolean)false, (int)3, null)) != null ? callableMemberDescriptor2.toVisibility() : null;
        return Intrinsics.areEqual((Object)Visibilities.Public.INSTANCE, visibility) || Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Internal.INSTANCE) && DescriptorUtilsKt.isPublishedApi((DeclarationDescriptor)((DeclarationDescriptor)callableMemberDescriptor));
    }

    private final boolean hasAnyAnnotation(KtAnnotated $this$hasAnyAnnotation, String ... annotationFqNames) {
        boolean bl;
        block1: {
            List list = $this$hasAnyAnnotation.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
            Sequence $this$any$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)hasAnyAnnotation.1.INSTANCE), (Function1)((Function1)new Function1<KtTypeReference, KotlinType>(this){
                final /* synthetic */ AnnotatePublicApisWithJvmOverloads this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final KotlinType invoke(@NotNull KtTypeReference it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (KotlinType)this.this$0.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE, (Object)it);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl2 = false;
                Iterable iterable = ArraysKt.toList((Object[])annotationFqNames);
                Intrinsics.checkNotNull((Object)it);
                FqName fqName = TypeUtilsKt.fqNameOrNull((KotlinType)it);
                if (!CollectionsKt.contains((Iterable)iterable, (Object)(fqName != null ? fqName.toString() : null))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcash/detektive/javacompat/AnnotatePublicApisWithJvmOverloads$ElementType;", "", "(Ljava/lang/String;I)V", "FUNCTION", "CONSTRUCTOR", "detektive"})
    public static final class ElementType
    extends Enum<ElementType> {
        public static final /* enum */ ElementType FUNCTION = new ElementType();
        public static final /* enum */ ElementType CONSTRUCTOR = new ElementType();
        private static final /* synthetic */ ElementType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ElementType[] values() {
            return (ElementType[])$VALUES.clone();
        }

        public static ElementType valueOf(String value) {
            return Enum.valueOf(ElementType.class, value);
        }

        @NotNull
        public static EnumEntries<ElementType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = elementTypeArray = new ElementType[]{ElementType.FUNCTION, ElementType.CONSTRUCTOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

