/*
 * Decompiled with CFR 0.152.
 */
package misk.aws2.s3;

import com.google.inject.Provides;
import jakarta.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.aws2.s3.config.S3Config;
import misk.cloud.aws.AwsRegion;
import misk.inject.KAbstractModule;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BI\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u0012\u0019\b\u0002\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u0007H\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmisk/aws2/s3/S3Module;", "Lmisk/inject/KAbstractModule;", "config", "Lmisk/aws2/s3/config/S3Config;", "configureSyncClient", "Lkotlin/Function1;", "Lsoftware/amazon/awssdk/services/s3/S3ClientBuilder;", "", "Lkotlin/ExtensionFunctionType;", "configureAsyncClient", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClientBuilder;", "<init>", "(Lmisk/aws2/s3/config/S3Config;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "configure", "s3Client", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "credentialsProvider", "Lsoftware/amazon/awssdk/auth/credentials/AwsCredentialsProvider;", "awsRegion", "Lmisk/cloud/aws/AwsRegion;", "s3AsyncClient", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "misk-aws2-s3"})
@SourceDebugExtension(value={"SMAP\nS3Module.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3Module.kt\nmisk/aws2/s3/S3Module\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n*L\n1#1,58:1\n49#2,2:59\n49#2,2:61\n*S KotlinDebug\n*F\n+ 1 S3Module.kt\nmisk/aws2/s3/S3Module\n*L\n22#1:59,2\n23#1:61,2\n*E\n"})
public class S3Module
extends KAbstractModule {
    @NotNull
    private final S3Config config;
    @NotNull
    private final Function1<S3ClientBuilder, Unit> configureSyncClient;
    @NotNull
    private final Function1<S3AsyncClientBuilder, Unit> configureAsyncClient;

    @JvmOverloads
    public S3Module(@NotNull S3Config config, @NotNull Function1<? super S3ClientBuilder, Unit> configureSyncClient, @NotNull Function1<? super S3AsyncClientBuilder, Unit> configureAsyncClient) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(configureSyncClient, (String)"configureSyncClient");
        Intrinsics.checkNotNullParameter(configureAsyncClient, (String)"configureAsyncClient");
        this.config = config;
        this.configureSyncClient = configureSyncClient;
        this.configureAsyncClient = configureAsyncClient;
    }

    public /* synthetic */ S3Module(S3Config s3Config, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            s3Config = new S3Config(null, 1, null);
        }
        if ((n & 2) != 0) {
            function1 = S3Module::_init_$lambda$0;
        }
        if ((n & 4) != 0) {
            function12 = S3Module::_init_$lambda$1;
        }
        this(s3Config, (Function1<? super S3ClientBuilder, Unit>)function1, (Function1<? super S3AsyncClientBuilder, Unit>)function12);
    }

    protected void configure() {
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AwsCredentialsProvider.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AwsRegion.class);
    }

    @Provides
    @Singleton
    @NotNull
    public final S3Client s3Client(@NotNull AwsCredentialsProvider credentialsProvider, @NotNull AwsRegion awsRegion) {
        Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
        String string = this.config.getRegion();
        if (string == null) {
            string = awsRegion.getName();
        }
        String region = string;
        S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(credentialsProvider)).region(Region.of((String)region));
        Intrinsics.checkNotNull((Object)builder);
        this.configureSyncClient.invoke((Object)builder);
        Object object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (S3Client)object;
    }

    @Provides
    @Singleton
    @NotNull
    public final S3AsyncClient s3AsyncClient(@NotNull AwsCredentialsProvider credentialsProvider, @NotNull AwsRegion awsRegion) {
        Intrinsics.checkNotNullParameter((Object)credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
        String string = this.config.getRegion();
        if (string == null) {
            string = awsRegion.getName();
        }
        String region = string;
        S3AsyncClientBuilder builder = (S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(credentialsProvider)).region(Region.of((String)region));
        Intrinsics.checkNotNull((Object)builder);
        this.configureAsyncClient.invoke((Object)builder);
        Object object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (S3AsyncClient)object;
    }

    @JvmOverloads
    public S3Module(@NotNull S3Config config, @NotNull Function1<? super S3ClientBuilder, Unit> configureSyncClient) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(configureSyncClient, (String)"configureSyncClient");
        this(config, configureSyncClient, null, 4, null);
    }

    @JvmOverloads
    public S3Module(@NotNull S3Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(config, null, null, 6, null);
    }

    @JvmOverloads
    public S3Module() {
        this(null, null, null, 7, null);
    }

    private static final Unit _init_$lambda$0(S3ClientBuilder s3ClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)s3ClientBuilder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(S3AsyncClientBuilder s3AsyncClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)s3AsyncClientBuilder, (String)"<this>");
        return Unit.INSTANCE;
    }
}

