/*
 * Decompiled with CFR 0.152.
 */
package misk.mcp;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.json.Json;
import misk.annotation.ExperimentalMiskApi;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import misk.mcp.McpPrompt;
import misk.mcp.McpResource;
import misk.mcp.McpTool;
import misk.mcp.MiskMcpServer;
import misk.mcp.config.McpConfig;
import misk.mcp.config.McpServerConfig;
import misk.mcp.internal.McpJsonKt;
import misk.mcp.internal.McpJsonRpcMessageUnmarshaller;
import misk.mcp.internal.MiskMcp;
import misk.web.marshal.Unmarshaller;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmisk/mcp/McpServerModule;", "Lmisk/inject/KAbstractModule;", "config", "Lmisk/mcp/config/McpConfig;", "<init>", "(Lmisk/mcp/config/McpConfig;)V", "configure", "", "providesMcpJson", "Lkotlinx/serialization/json/Json;", "Companion", "misk-mcp"})
@ExperimentalMiskApi
@SourceDebugExtension(value={"SMAP\nMcpServerModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerModule.kt\nmisk/mcp/McpServerModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n+ 3 Guice.kt\nmisk/inject/GuiceKt\n*L\n1#1,68:1\n56#2,10:69\n45#2:79\n63#2,3:80\n63#2,3:83\n63#2,3:86\n68#3:89\n68#3:90\n68#3:91\n90#3:92\n*S KotlinDebug\n*F\n+ 1 McpServerModule.kt\nmisk/mcp/McpServerModule\n*L\n27#1:69,10\n27#1:79\n30#1:80,3\n31#1:83,3\n32#1:86,3\n35#1:89\n36#1:90\n37#1:91\n40#1:92\n*E\n"})
public final class McpServerModule
extends KAbstractModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final McpConfig config;

    public McpServerModule(@NotNull McpConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    protected void configure() {
        void $this$to$iv;
        Set<Map.Entry<String, McpServerConfig>> set = this.config.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Object object = CollectionsKt.singleOrNull((Iterable)set);
        if (object == null) {
            boolean $i$a$-requireNotNull-McpServerModule$configure$22 = false;
            String $i$a$-requireNotNull-McpServerModule$configure$22 = "McpConfig must contain only one server configuration";
            throw new IllegalArgumentException($i$a$-requireNotNull-McpServerModule$configure$22.toString());
        }
        Map.Entry entry = (Map.Entry)object;
        Object k = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
        String serverName = (String)k;
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
        McpServerConfig serverConfig = (McpServerConfig)v;
        KAbstractModule kAbstractModule = this;
        LinkedBindingBuilder annotation$iv = null;
        boolean $i$f$multibind = false;
        KAbstractModule this_$iv$iv = this;
        boolean $i$f$newMultibinder = false;
        LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(Unmarshaller.Factory.class), annotation$iv).addBinding();
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"addBinding(...)");
        annotation$iv = linkedBindingBuilder;
        boolean $i$f$to = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$to$iv.to(McpJsonRpcMessageUnmarshaller.Factory.class), (String)"to(...)");
        KClass annotation$iv2 = null;
        boolean $i$f$newMultibinder2 = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this, (KClass)Reflection.getOrCreateKotlinClass(McpPrompt.class), annotation$iv2);
        annotation$iv2 = null;
        $i$f$newMultibinder2 = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this, (KClass)Reflection.getOrCreateKotlinClass(McpResource.class), annotation$iv2);
        annotation$iv2 = null;
        $i$f$newMultibinder2 = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this, (KClass)Reflection.getOrCreateKotlinClass(McpTool.class), annotation$iv2);
        boolean $i$f$setOfType = false;
        Provider promptsProvider = this.binder().getProvider(GuiceKt.toKey$default((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(McpPrompt.class)), null, (int)1, null));
        boolean $i$f$setOfType2 = false;
        Provider resourcesProvider = this.binder().getProvider(GuiceKt.toKey$default((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(McpResource.class)), null, (int)1, null));
        boolean $i$f$setOfType3 = false;
        Provider toolsProvider = this.binder().getProvider(GuiceKt.toKey$default((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(McpTool.class)), null, (int)1, null));
        boolean $i$f$keyOf = false;
        Key key = Key.get(MiskMcpServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"get(...)");
        Key serverKey = key;
        this.bind(serverKey).toProvider(() -> McpServerModule.configure$lambda$1(serverName, serverConfig, toolsProvider, resourcesProvider, promptsProvider));
    }

    @MiskMcp
    @Provides
    @NotNull
    public final Json providesMcpJson() {
        return McpJsonKt.getMcpJson();
    }

    private static final MiskMcpServer configure$lambda$1(String $serverName, McpServerConfig $serverConfig, Provider $toolsProvider, Provider $resourcesProvider, Provider $promptsProvider) {
        Object object = $toolsProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Set set = (Set)object;
        Object object2 = $resourcesProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Set set2 = (Set)object2;
        Object object3 = $promptsProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        return new MiskMcpServer($serverName, $serverConfig, set, set2, (Set)object3);
    }

    @JvmStatic
    @NotNull
    public static final McpServerModule create(@NotNull McpConfig config) {
        return Companion.create(config);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lmisk/mcp/McpServerModule$Companion;", "", "<init>", "()V", "create", "Lmisk/mcp/McpServerModule;", "config", "Lmisk/mcp/config/McpConfig;", "misk-mcp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final McpServerModule create(@NotNull McpConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new McpServerModule(config);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

