/*
 * Decompiled with CFR 0.152.
 */
package misk.mcp;

import io.modelcontextprotocol.kotlin.sdk.CallToolRequest;
import io.modelcontextprotocol.kotlin.sdk.CallToolResult;
import io.modelcontextprotocol.kotlin.sdk.GetPromptRequest;
import io.modelcontextprotocol.kotlin.sdk.GetPromptResult;
import io.modelcontextprotocol.kotlin.sdk.Implementation;
import io.modelcontextprotocol.kotlin.sdk.JSONRPCMessage;
import io.modelcontextprotocol.kotlin.sdk.ReadResourceRequest;
import io.modelcontextprotocol.kotlin.sdk.ReadResourceResult;
import io.modelcontextprotocol.kotlin.sdk.ServerCapabilities;
import io.modelcontextprotocol.kotlin.sdk.Tool;
import io.modelcontextprotocol.kotlin.sdk.server.Server;
import io.modelcontextprotocol.kotlin.sdk.server.ServerOptions;
import io.modelcontextprotocol.kotlin.sdk.shared.Transport;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.annotation.ExperimentalMiskApi;
import misk.mcp.McpPrompt;
import misk.mcp.McpResource;
import misk.mcp.McpTool;
import misk.mcp.config.ExtensionsKt;
import misk.mcp.config.McpServerConfig;
import misk.mcp.internal.MiskServerTransport;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BG\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0087@\u00a2\u0006\u0002\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lmisk/mcp/MiskMcpServer;", "Lio/modelcontextprotocol/kotlin/sdk/server/Server;", "name", "", "config", "Lmisk/mcp/config/McpServerConfig;", "tools", "", "Lmisk/mcp/McpTool;", "resources", "Lmisk/mcp/McpResource;", "prompts", "Lmisk/mcp/McpPrompt;", "<init>", "(Ljava/lang/String;Lmisk/mcp/config/McpServerConfig;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getName", "()Ljava/lang/String;", "getConfig", "()Lmisk/mcp/config/McpServerConfig;", "handleMessage", "", "message", "Lio/modelcontextprotocol/kotlin/sdk/JSONRPCMessage;", "sessionId", "(Lio/modelcontextprotocol/kotlin/sdk/JSONRPCMessage;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "misk-mcp"})
@ExperimentalMiskApi
@SourceDebugExtension(value={"SMAP\nMiskMcpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiskMcpServer.kt\nmisk/mcp/MiskMcpServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logging.kt\nmisk/logging/LoggingKt\n*L\n1#1,163:1\n1869#2,2:164\n1869#2,2:166\n1869#2,2:168\n13#3:170\n*S KotlinDebug\n*F\n+ 1 MiskMcpServer.kt\nmisk/mcp/MiskMcpServer\n*L\n121#1:164,2\n130#1:166,2\n140#1:168,2\n158#1:170\n*E\n"})
public final class MiskMcpServer
extends Server {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final McpServerConfig config;
    @NotNull
    private static final KLogger logger;

    public MiskMcpServer(@NotNull String name, @NotNull McpServerConfig config, @NotNull Set<? extends McpTool<?>> tools, @NotNull Set<? extends McpResource> resources, @NotNull Set<? extends McpPrompt> prompts) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        Intrinsics.checkNotNullParameter(prompts, (String)"prompts");
        super(new Implementation(name, config.getVersion()), new ServerOptions(new ServerCapabilities(null, null, null, !((Collection)prompts).isEmpty() ? ExtensionsKt.asPrompts(config.getPrompts()) : null, !((Collection)resources).isEmpty() ? ExtensionsKt.asResources(config.getResources()) : null, !((Collection)tools).isEmpty() ? ExtensionsKt.asTools(config.getTools()) : null), false, 2, null));
        this.name = name;
        this.config = config;
        this.onInitialized(() -> MiskMcpServer._init_$lambda$1(this));
        Iterable $this$forEach$iv = prompts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            McpPrompt prompt = (McpPrompt)element$iv;
            boolean bl = false;
            this.addPrompt(prompt.getName(), prompt.getDescription(), prompt.getArguments(), (Function2)new Function2<GetPromptRequest, Continuation<? super GetPromptResult>, Object>((Object)prompt){

                public final Object invoke(GetPromptRequest p0, Continuation<? super GetPromptResult> $completion) {
                    return ((McpPrompt)this.receiver).handler(p0, $completion);
                }
            });
        }
        $this$forEach$iv = resources;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            McpResource resource = (McpResource)element$iv;
            boolean bl = false;
            this.addResource(resource.getUri(), resource.getName(), resource.getDescription(), resource.getMimeType(), (Function2)new Function2<ReadResourceRequest, Continuation<? super ReadResourceResult>, Object>((Object)resource){

                public final Object invoke(ReadResourceRequest p0, Continuation<? super ReadResourceResult> $completion) {
                    return ((McpResource)this.receiver).handler(p0, $completion);
                }
            });
        }
        $this$forEach$iv = tools;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            McpTool tool = (McpTool)element$iv;
            boolean bl = false;
            Server.addTool$default((Server)this, (String)tool.getName(), (String)tool.getDescription(), (Tool.Input)tool.getInputSchema(), (Tool.Output)tool.getOutputSchema(), null, (Function2)((Function2)new Function2<CallToolRequest, Continuation<? super CallToolResult>, Object>((Object)tool){

                public final Object invoke(CallToolRequest p0, Continuation<? super CallToolResult> $completion) {
                    return ((McpTool)this.receiver).handler(p0, $completion);
                }
            }), (int)16, null);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final McpServerConfig getConfig() {
        return this.config;
    }

    @JvmOverloads
    @Nullable
    public final Object handleMessage(@NotNull JSONRPCMessage message, @Nullable String sessionId, @NotNull Continuation<? super Unit> $completion) {
        Transport transport = this.getTransport();
        MiskServerTransport miskServerTransport = transport instanceof MiskServerTransport ? (MiskServerTransport)transport : null;
        if (miskServerTransport == null) {
            boolean bl = false;
            String string = "MiskMcpServer requires a connected MiskServerTransport to handle messages";
            throw new IllegalStateException(string.toString());
        }
        Object object = miskServerTransport.handleMessage(message, sessionId, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object handleMessage$default(MiskMcpServer miskMcpServer, JSONRPCMessage jSONRPCMessage, String string, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return miskMcpServer.handleMessage(jSONRPCMessage, string, (Continuation<? super Unit>)continuation);
    }

    @JvmOverloads
    @Nullable
    public final Object handleMessage(@NotNull JSONRPCMessage message, @NotNull Continuation<? super Unit> $completion) {
        return MiskMcpServer.handleMessage$default(this, message, null, $completion, 2, null);
    }

    private static final Object lambda$1$lambda$0(MiskMcpServer this$0) {
        return "MCP server " + this$0.name + " initialized";
    }

    private static final Unit _init_$lambda$1(MiskMcpServer this$0) {
        logger.debug(() -> MiskMcpServer.lambda$1$lambda$0(this$0));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(MiskMcpServer.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmisk/mcp/MiskMcpServer$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "misk-mcp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

