/*
 * Decompiled with CFR 0.152.
 */
package misk.mcp;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.util.Types;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KClass;
import kotlinx.serialization.json.Json;
import misk.annotation.ExperimentalMiskApi;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import misk.inject.KInstallOnceModule;
import misk.mcp.McpPrompt;
import misk.mcp.McpResource;
import misk.mcp.McpSessionHandler;
import misk.mcp.McpTool;
import misk.mcp.MiskMcpServer;
import misk.mcp.action.McpStreamManager;
import misk.mcp.config.McpConfig;
import misk.mcp.config.McpServerConfig;
import misk.mcp.internal.McpJsonKt;
import misk.mcp.internal.McpJsonRpcMessageUnmarshaller;
import misk.mcp.internal.MiskMcp;
import misk.scope.ActionScoped;
import misk.web.HttpCall;
import misk.web.marshal.Unmarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmisk/mcp/McpServerModule;", "Lmisk/inject/KAbstractModule;", "name", "", "config", "Lmisk/mcp/config/McpConfig;", "groupAnnotationClass", "Lkotlin/reflect/KClass;", "", "<init>", "(Ljava/lang/String;Lmisk/mcp/config/McpConfig;Lkotlin/reflect/KClass;)V", "configure", "", "Companion", "CommonModule", "misk-mcp"})
@ExperimentalMiskApi
@SourceDebugExtension(value={"SMAP\nMcpServerModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerModule.kt\nmisk/mcp/McpServerModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n+ 3 Guice.kt\nmisk/inject/GuiceKt\n*L\n1#1,121:1\n65#2:122\n65#2:123\n65#2:124\n97#3:125\n43#3:126\n68#3:127\n68#3:128\n68#3:129\n97#3:130\n97#3:131\n*S KotlinDebug\n*F\n+ 1 McpServerModule.kt\nmisk/mcp/McpServerModule\n*L\n40#1:122\n41#1:123\n42#1:124\n48#1:125\n51#1:126\n57#1:127\n58#1:128\n59#1:129\n62#1:130\n75#1:131\n*E\n"})
public final class McpServerModule
extends KAbstractModule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final McpConfig config;
    @Nullable
    private final KClass<? extends Annotation> groupAnnotationClass;

    private McpServerModule(String name, McpConfig config, KClass<? extends Annotation> groupAnnotationClass) {
        this.name = name;
        this.config = config;
        this.groupAnnotationClass = groupAnnotationClass;
    }

    protected void configure() {
        Key key;
        Key key2;
        Key key3;
        KAbstractModule this_$iv;
        this.install((Module)new CommonModule());
        KAbstractModule kAbstractModule = this;
        KClass<? extends Annotation> annotation$iv = this.groupAnnotationClass;
        boolean $i$f$newMultibinder = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv, (KClass)Reflection.getOrCreateKotlinClass(McpPrompt.class), annotation$iv);
        this_$iv = this;
        annotation$iv = this.groupAnnotationClass;
        $i$f$newMultibinder = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv, (KClass)Reflection.getOrCreateKotlinClass(McpResource.class), annotation$iv);
        this_$iv = this;
        annotation$iv = this.groupAnnotationClass;
        $i$f$newMultibinder = false;
        KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv, (KClass)Reflection.getOrCreateKotlinClass(McpTool.class), annotation$iv);
        McpServerConfig mcpServerConfig = (McpServerConfig)this.config.get((Object)this.name);
        if (mcpServerConfig == null) {
            throw new IllegalArgumentException("No MCP server configuration found for [name=" + this.name + "] in [config=" + this.config + "]");
        }
        McpServerConfig serverConfig = mcpServerConfig;
        Binder binder = this.binder();
        KClass<? extends Annotation> a$iv = this.groupAnnotationClass;
        boolean $i$f$keyOf = false;
        if (a$iv == null) {
            Key key4 = Key.get(McpSessionHandler.class);
            key3 = key4;
            Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"get(...)");
        } else {
            Key key5 = Key.get(McpSessionHandler.class, (Class)JvmClassMappingKt.getJavaClass(a$iv));
            key3 = key5;
            Intrinsics.checkNotNullExpressionValue((Object)key5, (String)"get(...)");
        }
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)key3);
        Binder $this$configure_u24lambda_u240 = this.binder();
        boolean bl = false;
        Type[] typeArray = new Type[]{McpSessionHandler.class};
        Type[] typeParameters$iv = typeArray;
        boolean $i$f$parameterizedType = false;
        ParameterizedType parameterizedType = Types.newParameterizedType((Type)((Type)((Object)Optional.class)), (Type[])Arrays.copyOf(typeParameters$iv, typeParameters$iv.length));
        Intrinsics.checkNotNullExpressionValue((Object)parameterizedType, (String)"newParameterizedType(...)");
        TypeLiteral typeLiteral = GuiceKt.typeLiteral((Type)parameterizedType);
        Intrinsics.checkNotNull((Object)typeLiteral, (String)"null cannot be cast to non-null type com.google.inject.TypeLiteral<java.util.Optional<misk.mcp.McpSessionHandler>>");
        TypeLiteral optionalType = typeLiteral;
        Provider provider = $this$configure_u24lambda_u240.getProvider(GuiceKt.toKey((TypeLiteral)optionalType, this.groupAnnotationClass));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"run(...)");
        Provider mcpSessionHandlerProvider = provider;
        boolean $i$f$setOfType = false;
        Provider promptsProvider = this.binder().getProvider(GuiceKt.toKey((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(McpPrompt.class)), this.groupAnnotationClass));
        boolean $i$f$setOfType2 = false;
        Provider resourcesProvider = this.binder().getProvider(GuiceKt.toKey((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(McpResource.class)), this.groupAnnotationClass));
        boolean $i$f$setOfType3 = false;
        Provider toolsProvider = this.binder().getProvider(GuiceKt.toKey((TypeLiteral)GuiceKt.setOfType((KClass)Reflection.getOrCreateKotlinClass(McpTool.class)), this.groupAnnotationClass));
        KClass<? extends Annotation> a$iv2 = this.groupAnnotationClass;
        boolean $i$f$keyOf2 = false;
        if (a$iv2 == null) {
            Key key6 = Key.get(MiskMcpServer.class);
            key2 = key6;
            Intrinsics.checkNotNullExpressionValue((Object)key6, (String)"get(...)");
        } else {
            Key key7 = Key.get(MiskMcpServer.class, (Class)JvmClassMappingKt.getJavaClass(a$iv2));
            key2 = key7;
            Intrinsics.checkNotNullExpressionValue((Object)key7, (String)"get(...)");
        }
        Key serverKey = key2;
        Provider serverProvider = () -> McpServerModule.configure$lambda$1(this, serverConfig, mcpSessionHandlerProvider, toolsProvider, resourcesProvider, promptsProvider);
        ScopedBindingBuilder scopedBindingBuilder = this.bind(serverKey).toProvider(serverProvider);
        Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder, (String)"toProvider(...)");
        GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder);
        KClass<? extends Annotation> a$iv3 = this.groupAnnotationClass;
        boolean $i$f$keyOf3 = false;
        if (a$iv3 == null) {
            Key key8 = Key.get(McpStreamManager.class);
            key = key8;
            Intrinsics.checkNotNullExpressionValue((Object)key8, (String)"get(...)");
        } else {
            Key key9 = Key.get(McpStreamManager.class, (Class)JvmClassMappingKt.getJavaClass(a$iv3));
            key = key9;
            Intrinsics.checkNotNullExpressionValue((Object)key9, (String)"get(...)");
        }
        Key streamManagerKey = key;
        ScopedBindingBuilder scopedBindingBuilder2 = this.bind(streamManagerKey).toProvider((Provider)new Provider<McpStreamManager>((Provider<MiskMcpServer>)serverProvider){
            @Inject
            public ActionScoped<? extends HttpCall> httpCall;
            final /* synthetic */ Provider<MiskMcpServer> $serverProvider;
            {
                this.$serverProvider = $serverProvider;
            }

            public final ActionScoped<HttpCall> getHttpCall() {
                ActionScoped<? extends HttpCall> actionScoped = this.httpCall;
                if (actionScoped != null) {
                    return actionScoped;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"httpCall");
                return null;
            }

            public final void setHttpCall(ActionScoped<? extends HttpCall> actionScoped) {
                Intrinsics.checkNotNullParameter(actionScoped, (String)"<set-?>");
                this.httpCall = actionScoped;
            }

            public McpStreamManager get() {
                return new McpStreamManager(this.getHttpCall(), this.$serverProvider);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scopedBindingBuilder2, (String)"toProvider(...)");
        GuiceKt.asSingleton((ScopedBindingBuilder)scopedBindingBuilder2);
    }

    private static final MiskMcpServer configure$lambda$1(McpServerModule this$0, McpServerConfig $serverConfig, Provider $mcpSessionHandlerProvider, Provider $toolsProvider, Provider $resourcesProvider, Provider $promptsProvider) {
        String string = this$0.name;
        Object object = $mcpSessionHandlerProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        McpSessionHandler mcpSessionHandler = (McpSessionHandler)OptionalsKt.getOrNull((Optional)((Optional)object));
        Object object2 = $toolsProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Set set = CollectionsKt.toSet((Iterable)((Iterable)object2));
        Object object3 = $resourcesProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Set set2 = CollectionsKt.toSet((Iterable)((Iterable)object3));
        Object object4 = $promptsProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        return new MiskMcpServer(string, $serverConfig, mcpSessionHandler, set, set2, CollectionsKt.toSet((Iterable)((Iterable)object4)));
    }

    public /* synthetic */ McpServerModule(String name, McpConfig config, KClass groupAnnotationClass, DefaultConstructorMarker $constructor_marker) {
        this(name, config, (KClass<? extends Annotation>)groupAnnotationClass);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lmisk/mcp/McpServerModule$CommonModule;", "Lmisk/inject/KInstallOnceModule;", "<init>", "()V", "configure", "", "providesMcpJson", "Lkotlinx/serialization/json/Json;", "misk-mcp"})
    @SourceDebugExtension(value={"SMAP\nMcpServerModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerModule.kt\nmisk/mcp/McpServerModule$CommonModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n*L\n1#1,121:1\n56#2,10:122\n45#2:132\n63#2,3:133\n63#2,3:136\n63#2,3:139\n*S KotlinDebug\n*F\n+ 1 McpServerModule.kt\nmisk/mcp/McpServerModule$CommonModule\n*L\n105#1:122,10\n105#1:132\n108#1:133,3\n109#1:136,3\n110#1:139,3\n*E\n"})
    private static final class CommonModule
    extends KInstallOnceModule {
        protected void configure() {
            KAbstractModule kAbstractModule = (KAbstractModule)this;
            KClass annotation$iv = null;
            boolean $i$f$multibind = false;
            KAbstractModule this_$iv$iv = (KAbstractModule)this;
            boolean $i$f$newMultibinder = false;
            LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(Unmarshaller.Factory.class), annotation$iv).addBinding();
            Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"addBinding(...)");
            LinkedBindingBuilder $this$to$iv = linkedBindingBuilder;
            boolean $i$f$to = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$to$iv.to(McpJsonRpcMessageUnmarshaller.Factory.class), (String)"to(...)");
            KClass annotation$iv2 = null;
            boolean $i$f$newMultibinder2 = false;
            KAbstractModule.access$newMultibinder((KAbstractModule)((KAbstractModule)this), (KClass)Reflection.getOrCreateKotlinClass(McpPrompt.class), annotation$iv2);
            annotation$iv2 = null;
            $i$f$newMultibinder2 = false;
            KAbstractModule.access$newMultibinder((KAbstractModule)((KAbstractModule)this), (KClass)Reflection.getOrCreateKotlinClass(McpResource.class), annotation$iv2);
            annotation$iv2 = null;
            $i$f$newMultibinder2 = false;
            KAbstractModule.access$newMultibinder((KAbstractModule)((KAbstractModule)this), (KClass)Reflection.getOrCreateKotlinClass(McpTool.class), annotation$iv2);
        }

        @MiskMcp
        @Provides
        @NotNull
        public final Json providesMcpJson() {
            return McpJsonKt.getMcpJson();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\b\u0002\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bJ%\u0010\u0004\u001a\u00020\u0005\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\bJ\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lmisk/mcp/McpServerModule$Companion;", "", "<init>", "()V", "create", "Lmisk/mcp/McpServerModule;", "name", "", "config", "Lmisk/mcp/config/McpConfig;", "groupAnnotation", "Lkotlin/reflect/KClass;", "", "GA", "createWithNoGroup", "misk-mcp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final McpServerModule create(@NotNull String name, @NotNull McpConfig config, @Nullable KClass<? extends Annotation> groupAnnotation) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new McpServerModule(name, config, groupAnnotation, null);
        }

        public static /* synthetic */ McpServerModule create$default(Companion companion, String string, McpConfig mcpConfig, KClass kClass, int n, Object object) {
            if ((n & 4) != 0) {
                kClass = null;
            }
            return companion.create(string, mcpConfig, (KClass<? extends Annotation>)kClass);
        }

        public final /* synthetic */ <GA extends Annotation> McpServerModule create(String name, McpConfig config) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            boolean $i$f$create = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"GA");
            return this.create(name, config, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Annotation.class));
        }

        @JvmName(name="createWithNoGroup")
        @NotNull
        public final McpServerModule createWithNoGroup(@NotNull String name, @NotNull McpConfig config) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return this.create(name, config, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

