

### All Types

| Name | Summary |
|---|---|
| [misk.backoff.Backoff](../misk.backoff/-backoff/index.md) | Calculates how long to backoff on a retry. [Backoff](../misk.backoff/-backoff/index.md)s are stateful and not thread-safe |
| [misk.security.ssl.CertificateAndKey](../misk.security.ssl/-certificate-and-key/index.md) |  |
| [misk.security.ssl.CertStore](../misk.security.ssl/-cert-store/index.md) | A certificate and its private key. |
| [misk.security.ssl.CertStoreConfig](../misk.security.ssl/-cert-store-config/index.md) |  |
| [misk.clustering.Cluster](../misk.clustering/-cluster/index.md) | A [Cluster](../misk.clustering/-cluster/index.md) provides access to cluster membership for a service, allowing instances of a service to monitor the state of its peers |
| [misk.clustering.ClusterHashRing](../misk.clustering/-cluster-hash-ring/index.md) | A [ClusterHashRing](../misk.clustering/-cluster-hash-ring/index.md) maps resources to cluster members based on a consistent hash |
| [misk.clustering.ClusterResourceMapper](../misk.clustering/-cluster-resource-mapper/index.md) | A [ClusterResourceMapper](../misk.clustering/-cluster-resource-mapper/index.md) maps string based resource IDs onto members of a cluster for the purposes of resource ownership. The default [ClusterResourceMapper](../misk.clustering/-cluster-resource-mapper/index.md) is a [ClusterHashRing](../misk.clustering/-cluster-hash-ring/index.md) which performs a consistent hash across the cluster member, but [Cluster](../misk.clustering/-cluster/index.md)s can supply their own mappings if there is a mechanism specific to that cluster (or to supply a fake) |
| [misk.clustering.ClusterService](../misk.clustering/-cluster-service.md) | Marker interface for the service that produces a [Cluster](../misk.clustering/-cluster/index.md). |
| [misk.clustering.ClusterWatch](../misk.clustering/-cluster-watch.md) | A [ClusterWatch](../misk.clustering/-cluster-watch.md) is a callback function triggered when cluster membership changes |
| [misk.clustering.DefaultCluster](../misk.clustering/-default-cluster/index.md) | A [DefaultCluster](../misk.clustering/-default-cluster/index.md) is the default implementation of the [Cluster](../misk.clustering/-cluster/index.md), which relies on an outside source such as a cluster watcher to inform it as members become ready or not ready. The [DefaultCluster](../misk.clustering/-default-cluster/index.md) handles computing the actual cluster changes, and managing application watches that need to be triggered as the cluster changes. |
| [misk.backoff.DontRetryException](../misk.backoff/-dont-retry-exception/index.md) |  |
| [misk.concurrent.ExecutorServiceFactory](../misk.concurrent/-executor-service-factory/index.md) | Inject this rather than using the [Executors](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/Executors.html) factory class to create thread pools. Executors created with this factory will automatically be shut down when the service or test completes. |
| [misk.clustering.fake.ExplicitClusterResourceMapper](../misk.clustering.fake/-explicit-cluster-resource-mapper/index.md) | An [ExplicitClusterResourceMapper](../misk.clustering.fake/-explicit-cluster-resource-mapper/index.md) is a [ClusterResourceMapper](../misk.clustering/-cluster-resource-mapper/index.md) where the mapping is explicit managed. |
| [misk.backoff.ExponentialBackoff](../misk.backoff/-exponential-backoff/index.md) | Performs exponential backoff with optional jitter. Durations are supplied as functions, so that they can change dynamically as the system is running (e.g. in response to changes in dynamic flags) |
| [misk.clustering.fake.FakeCluster](../misk.clustering.fake/-fake-cluster/index.md) | A [FakeCluster](../misk.clustering.fake/-fake-cluster/index.md) is a [Cluster](../misk.clustering/-cluster/index.md) that is a fake. It delegates entirely to [DefaultCluster](../misk.clustering/-default-cluster/index.md), but allows us to keep [DefaultCluster](../misk.clustering/-default-cluster/index.md) internal and make it clear that [FakeCluster](../misk.clustering.fake/-fake-cluster/index.md) is only intended to be used for fakes. |
| [misk.clustering.fake.FakeClusterModule](../misk.clustering.fake/-fake-cluster-module/index.md) | [FakeClusterModule](../misk.clustering.fake/-fake-cluster-module/index.md) installs fake implementations of the clustering primitives for use in tests |
| [misk.resources.FakeFilesModule](../misk.resources/-fake-files-module/index.md) | Adds the provided fake files to the map used by [FilesystemLoaderBackend](#). |
| [misk.clustering.fake.lease.FakeLeaseManager](../misk.clustering.fake.lease/-fake-lease-manager/index.md) | A [FakeLeaseManager](../misk.clustering.fake.lease/-fake-lease-manager/index.md) provides explicit control over leases for the purposes of testing. By default a lease is considered held, but it can be explicitly marked as not held if desired |
| [misk.clustering.fake.lease.FakeLeaseModule](../misk.clustering.fake.lease/-fake-lease-module/index.md) | [FakeLeaseModule](../misk.clustering.fake.lease/-fake-lease-module/index.md) installs support for leasing using fakes |
| [misk.backoff.FlatBackoff](../misk.backoff/-flat-backoff/index.md) |  |
| [misk.resources.ForFakeFiles](../misk.resources/-for-fake-files/index.md) |  |
| [java.security.KeyStore](../misk.security.ssl/java.security.-key-store/index.md) (extensions in package misk.security.ssl) |  |
| [mu.KLogger](../misk.logging/mu.-k-logger/index.md) (extensions in package misk.logging) |  |
| [misk.clustering.lease.Lease](../misk.clustering.lease/-lease/index.md) | A [Lease](../misk.clustering.lease/-lease/index.md) is a cluster-wide time-based lock on a given resource. Leases are retrieved via [LeaseManager.requestLease](../misk.clustering.lease/-lease-manager/request-lease.md). A ready service instance will automatically attempt to acquire leases that it thinks it should own (typically based on the resource being leased consistently hashing to the service instance), and will continue to maintain the lease for as long as it is still ready. Leases should be released if the service transitions into not ready; to avoid flapping, service lease owners may want to delay releasing leases until they've been not ready for a particular amount of time. |
| [misk.clustering.lease.LeaseManager](../misk.clustering.lease/-lease-manager/index.md) |  |
| [misk.web.mediatype.MediaRange](../misk.web.mediatype/-media-range/index.md) | An RFC-2616 media range |
| [okhttp3.MediaType](../misk.web.mediatype/okhttp3.-media-type/index.md) (extensions in package misk.web.mediatype) |  |
| [misk.web.mediatype.MediaTypes](../misk.web.mediatype/-media-types/index.md) |  |
| [misk.clustering.NoMembersAvailableException](../misk.clustering/-no-members-available-exception/index.md) | Thrown if the cluster does not have any members available. |
| [misk.security.ssl.PemComboFile](../misk.security.ssl/-pem-combo-file/index.md) | A file containing a mix of PEM-encoded certificates and PEM-encoded private keys. Can be used both for trust stores (which certificate authorities a TLS client trusts) and also for TLS servers (which certificate chain a TLS server serves). |
| [misk.random.Random](../misk.random/-random/index.md) | Abstraction for Java's Random that allows for testing. |
| [misk.resources.ResourceLoader](../misk.resources/-resource-loader/index.md) | ResourceLoader is a testable API for loading resources from the classpath, from the filesystem, from memory, or from another [Backend](../misk.resources/-resource-loader/-backend/index.md) source. |
| [misk.resources.ResourceLoaderModule](../misk.resources/-resource-loader-module/index.md) |  |
| [misk.security.ssl.SslContextFactory](../misk.security.ssl/-ssl-context-factory/index.md) |  |
| [misk.security.ssl.SslLoader](../misk.security.ssl/-ssl-loader/index.md) | Loads keys and certificates from the file system. |
| [kotlin.String](../misk.web.mediatype/kotlin.-string/index.md) (extensions in package misk.web.mediatype) |  |
| [misk.logging.Tag](../misk.logging/-tag.md) |  |
| [misk.resources.TestingResourceLoaderModule](../misk.resources/-testing-resource-loader-module/index.md) | Can be used instead of [ResourceLoaderModule](../misk.resources/-resource-loader-module/index.md) in tests to load filesystem: resources using [FakeFilesystemLoaderBackend](#) |
| [misk.random.ThreadLocalRandom](../misk.random/-thread-local-random/index.md) | Abstraction for Java's ThreadLocalRandom that allows for testing. |
| [misk.security.ssl.TrustStore](../misk.security.ssl/-trust-store/index.md) | A set of trusted root certificates. |
| [misk.security.ssl.TrustStoreConfig](../misk.security.ssl/-trust-store-config/index.md) |  |
