[misk-core](../../index.md) / [misk.backoff](../index.md) / [Backoff](./index.md)

# Backoff

`interface Backoff`

Calculates how long to backoff on a retry. [Backoff](./index.md)s are stateful and not thread-safe

### Functions

| Name | Summary |
|---|---|
| [nextRetry](next-retry.md) | `abstract fun nextRetry(): `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html) |
| [reset](reset.md) | `abstract fun reset(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Resets the backoff, typically when a request has succeeded |

### Inheritors

| Name | Summary |
|---|---|
| [ExponentialBackoff](../-exponential-backoff/index.md) | `class ExponentialBackoff : `[`Backoff`](./index.md)<br>Performs exponential backoff with optional jitter. Durations are supplied as functions, so that they can change dynamically as the system is running (e.g. in response to changes in dynamic flags) |
| [FlatBackoff](../-flat-backoff/index.md) | `class FlatBackoff : `[`Backoff`](./index.md) |
