[misk-core](../../index.md) / [misk.backoff](../index.md) / [ExponentialBackoff](index.md) / [&lt;init&gt;](./-init-.md)

# &lt;init&gt;

`ExponentialBackoff(baseDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`

Creates a new unjittered [ExponentialBackoff](index.md) using a function for the base
and max retry delays.

### Parameters

`baseDelay` - The [Supplier](#) for the base delay

`maxDelay` - The [Supplier](#) for maximum amount of time to wait between retries`ExponentialBackoff(baseDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, jitter: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`

Creates a new [ExponentialBackoff](index.md) from fixed delays and jitter amounts

### Parameters

`baseDelay` - The base retry delay

`maxDelay` - The max amount of time to delay

`jitter` - The amount of jitter to introduce`ExponentialBackoff(baseDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`

Creates a new [ExponentialBackoff](index.md) from fixed delays, without jitter

### Parameters

`baseDelay` - The base retry delay

`maxDelay` - The max amount of time to delay`ExponentialBackoff(baseDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, jitter: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`

Performs exponential backoff with optional jitter. Durations are supplied as
functions, so that they can change dynamically as the system is running (e.g.
in response to changes in dynamic flags)

