[misk-core](../../index.md) / [misk.backoff](../index.md) / [ExponentialBackoff](./index.md)

# ExponentialBackoff

`class ExponentialBackoff : `[`Backoff`](../-backoff/index.md)

Performs exponential backoff with optional jitter. Durations are supplied as
functions, so that they can change dynamically as the system is running (e.g.
in response to changes in dynamic flags)

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `ExponentialBackoff(baseDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`<br>Creates a new unjittered [ExponentialBackoff](./index.md) using a function for the base and max retry delays.`ExponentialBackoff(baseDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, jitter: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`<br>Creates a new [ExponentialBackoff](./index.md) from fixed delays and jitter amounts`ExponentialBackoff(baseDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`<br>Creates a new [ExponentialBackoff](./index.md) from fixed delays, without jitter`ExponentialBackoff(baseDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, maxDelay: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`, jitter: () -> `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html)`)`<br>Performs exponential backoff with optional jitter. Durations are supplied as functions, so that they can change dynamically as the system is running (e.g. in response to changes in dynamic flags) |

### Functions

| Name | Summary |
|---|---|
| [nextRetry](next-retry.md) | `fun nextRetry(): `[`Duration`](https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html) |
| [reset](reset.md) | `fun reset(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Resets the backoff, typically when a request has succeeded |
