[misk-core](../index.md) / [misk.backoff](./index.md)

## Package misk.backoff

### Types

| Name | Summary |
|---|---|
| [Backoff](-backoff/index.md) | `interface Backoff`<br>Calculates how long to backoff on a retry. [Backoff](-backoff/index.md)s are stateful and not thread-safe |
| [ExponentialBackoff](-exponential-backoff/index.md) | `class ExponentialBackoff : `[`Backoff`](-backoff/index.md)<br>Performs exponential backoff with optional jitter. Durations are supplied as functions, so that they can change dynamically as the system is running (e.g. in response to changes in dynamic flags) |
| [FlatBackoff](-flat-backoff/index.md) | `class FlatBackoff : `[`Backoff`](-backoff/index.md) |

### Exceptions

| Name | Summary |
|---|---|
| [DontRetryException](-dont-retry-exception/index.md) | `class DontRetryException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html) |

### Functions

| Name | Summary |
|---|---|
| [retry](retry.md) | `fun <A> retry(upTo: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, withBackoff: `[`Backoff`](-backoff/index.md)`, f: (retryCount: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`) -> `[`A`](retry.md#A)`): `[`A`](retry.md#A)<br>Retries the provided function up to a certain number of times, applying the given backoff between each retry. The retry function is provided with current retry count, in case this is relevant |
