[misk-core](../../index.md) / [misk.clustering.fake.lease](../index.md) / [FakeLeaseManager](./index.md)

# FakeLeaseManager

`@Singleton class FakeLeaseManager : `[`LeaseManager`](../../misk.clustering.lease/-lease-manager/index.md)

A [FakeLeaseManager](./index.md) provides explicit control over leases for the purposes of testing. By
default a lease is considered held, but it can be explicitly marked as not held if desired

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `FakeLeaseManager()`<br>A [FakeLeaseManager](./index.md) provides explicit control over leases for the purposes of testing. By default a lease is considered held, but it can be explicitly marked as not held if desired |

### Functions

| Name | Summary |
|---|---|
| [isLeaseHeld](is-lease-held.md) | `fun isLeaseHeld(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [markLeaseHeld](mark-lease-held.md) | `fun markLeaseHeld(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [markLeaseHeldElsewhere](mark-lease-held-elsewhere.md) | `fun markLeaseHeldElsewhere(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [requestLease](request-lease.md) | `fun requestLease(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Lease`](../../misk.clustering.lease/-lease/index.md)<br>Registers interest in the lease with the given name. Service instances should register their interest in leases as soon as they know about them; this gives the process an opportunity to notify the underlying cluster system that it is interested in the lease, or to setup other background tasks to acquire the lease if necessary. Note that registering interest in a lease doesn't necessarily mean that this service instance will attempt to acquire the lease; many clustering systems will only try to acquire leases for resources that they think they should own based on some consistent hashing system |
