[misk-core](../../index.md) / [misk.clustering.fake](../index.md) / [FakeCluster](./index.md)

# FakeCluster

`@Singleton class FakeCluster : `[`ClusterService`](../../misk.clustering/-cluster-service.md)`, `[`Cluster`](../../misk.clustering/-cluster/index.md)

A [FakeCluster](./index.md) is a [Cluster](../../misk.clustering/-cluster/index.md) that is a fake. It delegates entirely to [DefaultCluster](../../misk.clustering/-default-cluster/index.md),
but allows us to keep [DefaultCluster](../../misk.clustering/-default-cluster/index.md) internal and make it clear that [FakeCluster](./index.md)
is only intended to be used for fakes.

NB(mmihic): I'd prefer for this to be in the misk-testing module, but it can't since it
relies on [DefaultCluster](../../misk.clustering/-default-cluster/index.md) and we want to leave [DefaultCluster](../../misk.clustering/-default-cluster/index.md) internal

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `FakeCluster(resourceMapper: `[`ExplicitClusterResourceMapper`](../-explicit-cluster-resource-mapper/index.md)`)`<br>`FakeCluster()` |

### Properties

| Name | Summary |
|---|---|
| [resourceMapper](resource-mapper.md) | `val resourceMapper: `[`ExplicitClusterResourceMapper`](../-explicit-cluster-resource-mapper/index.md) |

### Functions

| Name | Summary |
|---|---|
| [clusterChanged](cluster-changed.md) | `fun clusterChanged(membersBecomingReady: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](../../misk.clustering/-cluster/-member/index.md)`> = setOf(), membersBecomingNotReady: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](../../misk.clustering/-cluster/-member/index.md)`> = setOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [watch](watch.md) | `fun watch(watch: `[`ClusterWatch`](../../misk.clustering/-cluster-watch.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Registers interest in cluster changes |

### Companion Object Properties

| Name | Summary |
|---|---|
| [self](self.md) | `val self: `[`Cluster.Member`](../../misk.clustering/-cluster/-member/index.md) |
| [SELF_IP](-s-e-l-f_-i-p.md) | `const val SELF_IP: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [SELF_NAME](-s-e-l-f_-n-a-m-e.md) | `const val SELF_NAME: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
