[misk-core](../../index.md) / [misk.clustering.lease](../index.md) / [LeaseManager](./index.md)

# LeaseManager

`interface LeaseManager`

### Functions

| Name | Summary |
|---|---|
| [requestLease](request-lease.md) | `abstract fun requestLease(name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Lease`](../-lease/index.md)<br>Registers interest in the lease with the given name. Service instances should register their interest in leases as soon as they know about them; this gives the process an opportunity to notify the underlying cluster system that it is interested in the lease, or to setup other background tasks to acquire the lease if necessary. Note that registering interest in a lease doesn't necessarily mean that this service instance will attempt to acquire the lease; many clustering systems will only try to acquire leases for resources that they think they should own based on some consistent hashing system |

### Inheritors

| Name | Summary |
|---|---|
| [FakeLeaseManager](../../misk.clustering.fake.lease/-fake-lease-manager/index.md) | `class FakeLeaseManager : `[`LeaseManager`](./index.md)<br>A [FakeLeaseManager](../../misk.clustering.fake.lease/-fake-lease-manager/index.md) provides explicit control over leases for the purposes of testing. By default a lease is considered held, but it can be explicitly marked as not held if desired |
