[misk-core](../../index.md) / [misk.clustering.lease](../index.md) / [Lease](./index.md)

# Lease

`interface Lease`

A [Lease](./index.md) is a cluster-wide time-based lock on a given resource. Leases are retrieved via
[LeaseManager.requestLease](../-lease-manager/request-lease.md). A ready service instance will automatically attempt to acquire
leases that it thinks it should own (typically based on the resource being leased consistently
hashing to the service instance), and will continue to maintain the lease for as long as it is
still ready. Leases should be released if the service transitions into not ready; to avoid
flapping, service lease owners may want to delay releasing leases until they've been not ready
for a particular amount of time.

### Types

| Name | Summary |
|---|---|
| [StateChangeListener](-state-change-listener/index.md) | `interface StateChangeListener` |

### Properties

| Name | Summary |
|---|---|
| [name](name.md) | `abstract val name: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

### Functions

| Name | Summary |
|---|---|
| [addListener](add-listener.md) | `abstract fun addListener(listener: `[`Lease.StateChangeListener`](-state-change-listener/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Registers a listener that is called on lease state changes. |
| [checkHeld](check-held.md) | `abstract fun checkHeld(): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
