[misk-core](../../index.md) / [misk.clustering](../index.md) / [ClusterResourceMapper](./index.md)

# ClusterResourceMapper

`interface ClusterResourceMapper`

A [ClusterResourceMapper](./index.md) maps string based resource IDs onto members of a cluster for the
purposes of resource ownership. The default [ClusterResourceMapper](./index.md) is a [ClusterHashRing](../-cluster-hash-ring/index.md)
which performs a consistent hash across the cluster member, but [Cluster](../-cluster/index.md)s can supply their
own mappings if there is a mechanism specific to that cluster (or to supply a fake)

### Functions

| Name | Summary |
|---|---|
| [get](get.md) | `abstract operator fun get(resourceId: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`): `[`Cluster.Member`](../-cluster/-member/index.md) |

### Inheritors

| Name | Summary |
|---|---|
| [ClusterHashRing](../-cluster-hash-ring/index.md) | `class ClusterHashRing : `[`ClusterResourceMapper`](./index.md)<br>A [ClusterHashRing](../-cluster-hash-ring/index.md) maps resources to cluster members based on a consistent hash |
| [ExplicitClusterResourceMapper](../../misk.clustering.fake/-explicit-cluster-resource-mapper/index.md) | `class ExplicitClusterResourceMapper : `[`ClusterResourceMapper`](./index.md)<br>An [ExplicitClusterResourceMapper](../../misk.clustering.fake/-explicit-cluster-resource-mapper/index.md) is a [ClusterResourceMapper](./index.md) where the mapping is explicit managed. |
