[misk-core](../../index.md) / [misk.clustering](../index.md) / [Cluster](./index.md)

# Cluster

`interface Cluster`

A [Cluster](./index.md) provides access to cluster membership for a service, allowing instances of a service
to monitor the state of its peers

### Types

| Name | Summary |
|---|---|
| [Changes](-changes/index.md) | `data class Changes` |
| [Member](-member/index.md) | `data class Member` |
| [Snapshot](-snapshot/index.md) | `data class Snapshot`<br>[Snapshot](-snapshot/index.md) is a consistent moment-in-time view of the cluster state |

### Properties

| Name | Summary |
|---|---|
| [snapshot](snapshot.md) | `abstract val snapshot: `[`Cluster.Snapshot`](-snapshot/index.md)<br>The current moment-in-time view of the cluster state |

### Functions

| Name | Summary |
|---|---|
| [newResourceMapper](new-resource-mapper.md) | `open fun newResourceMapper(readyMembers: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](-member/index.md)`>): `[`ClusterResourceMapper`](../-cluster-resource-mapper/index.md) |
| [watch](watch.md) | `abstract fun watch(watch: `[`ClusterWatch`](../-cluster-watch.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Registers interest in cluster changes |

### Inheritors

| Name | Summary |
|---|---|
| [DefaultCluster](../-default-cluster/index.md) | `class DefaultCluster : AbstractExecutionThreadService, `[`Cluster`](./index.md)`, `[`ClusterService`](../-cluster-service.md)<br>A [DefaultCluster](../-default-cluster/index.md) is the default implementation of the [Cluster](./index.md), which relies on an outside source such as a cluster watcher to inform it as members become ready or not ready. The [DefaultCluster](../-default-cluster/index.md) handles computing the actual cluster changes, and managing application watches that need to be triggered as the cluster changes. |
| [FakeCluster](../../misk.clustering.fake/-fake-cluster/index.md) | `class FakeCluster : `[`ClusterService`](../-cluster-service.md)`, `[`Cluster`](./index.md)<br>A [FakeCluster](../../misk.clustering.fake/-fake-cluster/index.md) is a [Cluster](./index.md) that is a fake. It delegates entirely to [DefaultCluster](../-default-cluster/index.md), but allows us to keep [DefaultCluster](../-default-cluster/index.md) internal and make it clear that [FakeCluster](../../misk.clustering.fake/-fake-cluster/index.md) is only intended to be used for fakes. |
