[misk-core](../../index.md) / [misk.clustering](../index.md) / [DefaultCluster](./index.md)

# DefaultCluster

`@Singleton class DefaultCluster : AbstractExecutionThreadService, `[`Cluster`](../-cluster/index.md)`, `[`ClusterService`](../-cluster-service.md)

A [DefaultCluster](./index.md) is the default implementation of the [Cluster](../-cluster/index.md), which relies on an outside
source such as a cluster watcher to inform it as members become ready or not ready. The
[DefaultCluster](./index.md) handles computing the actual cluster changes, and managing application watches
that need to be triggered as the cluster changes.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `DefaultCluster(self: `[`Cluster.Member`](../-cluster/-member/index.md)`, newResourceMapperFn: (members: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](../-cluster/-member/index.md)`>) -> `[`ClusterResourceMapper`](../-cluster-resource-mapper/index.md)` = { ClusterHashRing(it) })`<br>A [DefaultCluster](./index.md) is the default implementation of the [Cluster](../-cluster/index.md), which relies on an outside source such as a cluster watcher to inform it as members become ready or not ready. The [DefaultCluster](./index.md) handles computing the actual cluster changes, and managing application watches that need to be triggered as the cluster changes. |

### Properties

| Name | Summary |
|---|---|
| [snapshot](snapshot.md) | `val snapshot: `[`Cluster.Snapshot`](../-cluster/-snapshot/index.md)<br>The current moment-in-time view of the cluster state |

### Functions

| Name | Summary |
|---|---|
| [clusterChanged](cluster-changed.md) | `fun clusterChanged(membersBecomingReady: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](../-cluster/-member/index.md)`> = setOf(), membersBecomingNotReady: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](../-cluster/-member/index.md)`> = setOf()): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Triggers a change to the cluster in response members becoming ready or not ready |
| [newResourceMapper](new-resource-mapper.md) | `fun newResourceMapper(readyMembers: `[`Set`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)`<`[`Cluster.Member`](../-cluster/-member/index.md)`>): `[`ClusterResourceMapper`](../-cluster-resource-mapper/index.md) |
| [run](run.md) | `fun run(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Runs the internal event loop that handles requests to add watches or cluster changes. We use a single threaded event loop to ensure that watches get consistent diffs for the cluster without being racy or requiring locks that span application code (which might result in deadlocks). When a watch is registered, it is provided with the cluster membership as it is known at that time, and then receives diffs as they arrive. |
| [startUp](start-up.md) | `fun startUp(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [syncPoint](sync-point.md) | `fun syncPoint(callback: () -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Triggers a callback once all of the actions on the queue have been processed. Useful for writing deterministic tests |
| [triggerShutdown](trigger-shutdown.md) | `fun triggerShutdown(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [watch](watch.md) | `fun watch(watch: `[`ClusterWatch`](../-cluster-watch.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Adds a new cluster watch |

### Companion Object Properties

| Name | Summary |
|---|---|
| [log](log.md) | `val log: KLogger` |
