[misk-core](../index.md) / [misk.clustering](./index.md)

## Package misk.clustering

### Types

| Name | Summary |
|---|---|
| [Cluster](-cluster/index.md) | `interface Cluster`<br>A [Cluster](-cluster/index.md) provides access to cluster membership for a service, allowing instances of a service to monitor the state of its peers |
| [ClusterHashRing](-cluster-hash-ring/index.md) | `class ClusterHashRing : `[`ClusterResourceMapper`](-cluster-resource-mapper/index.md)<br>A [ClusterHashRing](-cluster-hash-ring/index.md) maps resources to cluster members based on a consistent hash |
| [ClusterResourceMapper](-cluster-resource-mapper/index.md) | `interface ClusterResourceMapper`<br>A [ClusterResourceMapper](-cluster-resource-mapper/index.md) maps string based resource IDs onto members of a cluster for the purposes of resource ownership. The default [ClusterResourceMapper](-cluster-resource-mapper/index.md) is a [ClusterHashRing](-cluster-hash-ring/index.md) which performs a consistent hash across the cluster member, but [Cluster](-cluster/index.md)s can supply their own mappings if there is a mechanism specific to that cluster (or to supply a fake) |
| [ClusterService](-cluster-service.md) | `interface ClusterService : Service`<br>Marker interface for the service that produces a [Cluster](-cluster/index.md). |
| [DefaultCluster](-default-cluster/index.md) | `class DefaultCluster : AbstractExecutionThreadService, `[`Cluster`](-cluster/index.md)`, `[`ClusterService`](-cluster-service.md)<br>A [DefaultCluster](-default-cluster/index.md) is the default implementation of the [Cluster](-cluster/index.md), which relies on an outside source such as a cluster watcher to inform it as members become ready or not ready. The [DefaultCluster](-default-cluster/index.md) handles computing the actual cluster changes, and managing application watches that need to be triggered as the cluster changes. |

### Exceptions

| Name | Summary |
|---|---|
| [NoMembersAvailableException](-no-members-available-exception/index.md) | `class NoMembersAvailableException : `[`Exception`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>Thrown if the cluster does not have any members available. |

### Type Aliases

| Name | Summary |
|---|---|
| [ClusterWatch](-cluster-watch.md) | `typealias ClusterWatch = (`[`Cluster.Changes`](-cluster/-changes/index.md)`) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>A [ClusterWatch](-cluster-watch.md) is a callback function triggered when cluster membership changes |
